FUNCTION Flux2AB, Flux, Lbda, SI=SI, Arcsec=Arcsec

; Lbda is in A
; Flux is in erg/s/cm2 if option SI is not set
; Flux is in kg/m/sec3 if option SI is set
; Flux is in arcsec-2 if option Sec is set
; Flux is in A-1 if option A is set
; result is AB magnitude

c = 299792458.0 ; in m/s
l = Lbda*1.e-10 ; in m
asec = 1.0/206265.0 ; arcsec in radian

F = Flux
if Keyword_set(Arcsec) then begin
    F = Flux*asec^2
endif

if ~Keyword_set(SI) then begin
    AB = -73.60 -2.5*alog10(l^2*F/c)
endif else begin
    AB = -56.10 -2.5*alog10(l^2*F/c)
endelse



return, AB

end

