FUNCTION AB2Flux, AB, Lbda, SI=SI, Arcsec=Arcsec

; AB is the AB magnitude
; Lbda is in A
; Flux will be in erg/s/cm2 if option SI is not set
; Flux will be in kg/m/sec3 if option SI is set
; Flux will be in arcsec-2 if option Sec is set
; Flux will be in A-1 if option A is set

c = 299792458.0 ; in m/s
l = Lbda*1.e-10 ; in m
asec = 1.0/206265.0 ; arcsec in radian


if ~Keyword_set(SI) then begin
    Flux = 10^(-0.4*(AB+48.60)-10)*c/l^2
endif else begin
    Flux = 10^(-0.4*(AB+48.60)-3)*c/l^2
endelse

if Keyword_set(Arcsec) then begin
    Flux = Flux/asec^2
endif

return, Flux

end

