/*

$Id: terminate.c,v 1.2 2007/03/01 12:38:26 jim Exp $

*/

#include <stdio.h>
#include "imcore.h"
#include "util.h"

extern void restack(ap_t *ap, int ip) {
    int i,ib;

    ib = ap->parent[ip].first;
    for(i = ap->ibstack - ap->parent[ip].pnop; i < ap->ibstack-1;  i++) {

        /* Stash all blocks back in a burst: */
    
        ap->bstack[i] = ib;
        ib = ap->blink[ib];
    }

    /* and the last one: */

    ap->bstack[ap->ibstack-1] = ib;
    ap->ibstack -= ap->parent[ip].pnop;

    /* Put parent name back on stack: */

    ap->pstack[--ap->ipstack] = ip;

    /* Mark that parent inactive: */

    ap->parent[ip].pnop = -1;
    ap->parent[ip].pnbp = -1;
}

extern void terminate(ap_t *ap) {
    int ip,status;

    /* Search through all possible parents!  */

    for (ip = 1; ip <= ap->maxip; ip++) {
        if(ap->parent[ip].pnop != -1) {
            if(ap->parent[ip].pnop == ap->parent[ip].growing) {

                /* That's a termination: */

                if((ap->parent[ip].pnop >= ap->ipnop &&
                    ap->parent[ip].touch == 0) &&
                    (ap->parent[ip].pnbp < (ap->parent[ip].pnop)/2)) {
		    extract_data(ap,ip);
                    
                    /* Call the processing routine */

		    status = process_results(ap);
		    if (status != VIR_OK) {
			restack(ap,ip);
			continue;
		    }
                }
                restack(ap,ip);
            } else {

                /* This parent still active: */

                ap->parent[ip].growing = ap->parent[ip].pnop;
            }
        }
    }
}

extern void apfu(ap_t *ap) {
    int ip, big, ipbig;

    /* Search through all possible parents and just junk the biggest
       one to free space:  */

    big = 0;
    ipbig = 0;
    for (ip = 1; ip <= ap->maxip; ip++) {
        if(ap->parent[ip].pnop != -1) {
            if(ap->parent[ip].pnop > big) {
                big = ap->parent[ip].pnop;
                ipbig = ip;
            }
        }
    }
    if(big > 0) {
        restack(ap, ipbig);

        /* clearout lastline references to this parent: */

        for (ip = 0; ip <= ap->lsiz; ip++)
            if(ap->lastline[ip] == ipbig) ap->lastline[ip] = 0;
    }
}

extern void extract_data(ap_t *ap, int ip) {
    int ib,i,np,nn;
    unsigned char *mflag;

    /* Check the size of the workspace and see if it's big enough. If it
       isn't then increase the size until it is */

    np = ap->parent[ip].pnop;
    if (ap->npl < np) {
        ap->plarray = cpl_realloc(ap->plarray,np*sizeof(plstruct));
	ap->npl = np;
    }

    /* Pull the info out now */

    ib = ap->parent[ip].first;
    ap->npl_pix = np;
    mflag = ap->mflag;
    for (i = 0; i < np; i++) {
        ap->plarray[i].x = ap->plessey[ib].x + 1;
        ap->plarray[i].y = ap->plessey[ib].y + 1;
	ap->plarray[i].z = ap->plessey[ib].z;
	ap->plarray[i].zsm = ap->plessey[ib].zsm;
	nn = ap->plessey[ib].y*ap->lsiz + ap->plessey[ib].x;
	mflag[nn] = MF_OBJPIX;
        ib = ap->blink[ib];
    }
}

/*

$Log: terminate.c,v $
Revision 1.2  2007/03/01 12:38:26  jim
Small modifications after a bit of code checking

Revision 1.1  2005/09/13 13:25:31  jim
Initial entry after modifications to make cpl compliant


*/
