#! /usr/bin/ksh

# indique le nom du fichier d'amas de conditions initiales pour la
# simulation $1

NomSimul=$1

RepAmas=$HOME"/AMAS/evols/"

for SousRep in "./" "parc_PC/cond_ini/" "reseau_SUN/"; do
    [[ -z $RepCI ]] && [[ -d $RepAmas/$SousRep/$NomSimul ]] && RepCI="$RepAmas/$SousRep/$NomSimul/"
done

if [[ -z $RepCI ]]; then
    print -u2 "!!! Pas trouve le repertoire de cond. initiales pour $NomSimul !!!"
    exit 1
fi

FichCI=$(ls -l $RepCI/*%0+(0)%AMAS.xdr 2> /dev/null | gawk '{print $NF}')

[[ -n $FichCI ]] || {
    print -u2 "!!! Pas trouve de fichier d'amas pour les cond. initiales de $NomSimul !!!"
    exit 1
}

[[ -f $FichCI ]] || {
    print -u2 "!!! Le fichier de cond. initiales ($FichCI) n'existe pas !!!"
    exit 1
}

print $FichCI


