#!/usr/bin/zsh

# Simulation Wo1_7_126k: merger at around T=150

nmin=150
nmax=800

for file in $(ls Splotch4_????_part.asc.gz); do
    num=${file%_part.asc.gz}
    num=${num#Splotch4_}
    if (( num >= nmin )) && (( num <= nmax )); then
	echo $file
	triax_file=${file%_part.asc.gz}_triax.asc.gz
	pot_file=${file%_part.asc.gz}_pot.asc.gz
	if [[ -f $triax_file ]]; then
	    print -u2 "- File $triax_file exists; $file skipped"
	else
	    print -u2 "+ Creating $triax_file..."
	    [[ -f $pot_file ]] && rm $pot_file
	    triaxiality_analysis_ellan.sh -eps 0.01 -p $pot_file < $file | gzip --to-stdout > $triax_file
	    mv __ellan__particle_sequence.asc ${file%_part.asc.gz}_ellan_seq.asc
	    gzip ${file%_part.asc.gz}_ellan_seq.asc
        fi
    fi
done
