#!/usr/bin/zsh

# Driver to run ELLAN shape analysis code on 
# all the snapshots of a nemo binary data file

function clean_up {
    print -u2 "... cleaning up"
    rm /tmp/$$'_'*
}

trap "clean_up" EXIT

[[ -z $NEMO ]] && source ~/AMAS/Nemo/nemo_start.sh # We will be using some Nemo stuff...


nmin=1
nmax=100000
step=1

# Values on command line

while [[ $1 = -* ]]; do
    case $1 in
        -nmin   ) nmin=$2; shift 2;;
        -nmax   ) nmax=$2; shift 2;;
        -step  ) nmax=$2; shift 2;;

        *       )
              print -u2 "!!! Important message from ${0##*/}: What exactly do you mean with $1, you magnificient weirdo? !!!"
              exit 1 ;;
    esac
done

for (( isnap=nmin; isnap<=nmax; isnap=isnpa+step )); do
    
XXXX
for file in $(ls Splotch4_????_part.asc.gz); do
    num=${file%_part.asc.gz}
    num=${num#Splotch4_}
    if (( num >= nmin )) && (( num <= nmax )); then
	echo $file
	triax_file=${file%_part.asc.gz}_triax.asc.gz
	pot_file=${file%_part.asc.gz}_pot.asc.gz
	if [[ -f $triax_file ]]; then
	    print -u2 "- File $triax_file exists; $file skipped"
	else
	    print -u2 "+ Creating $triax_file..."
	    [[ -f $pot_file ]] && rm $pot_file
	    triaxiality_analysis_ellan.sh -eps 0.01 -p $pot_file < $file | gzip --to-stdout > $triax_file
	    mv __ellan__particle_sequence.asc ${file%_part.asc.gz}_ellan_seq.asc
	    gzip ${file%_part.asc.gz}_ellan_seq.asc
        fi
    fi
done
