#!/usr/bin/zsh
# Uses a bunch of Nemo tools, most importantly Barnes & Hut 
# tree code to compute grav accelerations and potential for an N-body configuration

# Input data must be 4 columns: m x y z

# Output is 4 columns: ax ay az pot


soft_length=0.01
open_angle=1.0

while [[ $1 = -* ]]; do
    case $1 in

        -eps   ) soft_length=$2; shift 2;;
        -theta ) open_angle=$2; shift 2;;
        -nbody ) nbody=$2; shift 2;;
        *      )
              print -u2 "!!! What exactly do you mean with $1, you magnificient weirdo? !!!"
              exit 1 ;;
    esac
done

source ~/AMAS/Nemo/nemo_start.sh

grep -v '^ *#' |\
    if [[ -z $nbody ]]; then
       cat > /tmp/tmp_$$
       tabtos in="/tmp/tmp_$$" out=- block1="mass,pos" 
    else
       tabtos in=- out=- block1="mass,pos" nbody=$nbody
    fi |\
hackforce in=- out=- eps=$soft_length tol=$open_angle |\
snapprint in=- format="%12.5e" options="ax,ay,az,phi" 

[[ -f /tmp/tmp_$$ ]] && rm /tmp/tmp_$$