#!/bin/zsh

Er=0.8
Es=-1
N=300
Ns=50
suffix="OOPs.asc"
remove_empty=1
other_options=""
nice_level=19
nbody2xdr=Pau_Nbody4_1CompWithCentralBH_ASCII2AmasXDR

while [[ $1 = -* ]]; do
        case $1 in
                -bin ) binary=1; shift 1 ;;
                -Er ) Er=$2; shift 2 ;;
                -Es ) Es=$2; shift 2 ;;
                -N  ) N=$2;  shift 2 ;;
                -Ns ) Ns=$2;  shift 2 ;;
                -nice ) nice_level=$2; shift 2 ;;
		-z  ) compress=1; shift 1 ;;
                -keep_empty ) unset remove_empty; shift 1 ;;
		-mass_bins  ) other_options="$other_options -mass_bins $2 $3"; shift 3 ;;
                -s|-S|-surf_density ) surf_density=1; suffix="SurfOOPs.asc"; shift 1 ;;
                -2comp ) nbody2xdr=Pau_Nbody4_2CompWithCentralBH_ASCII2AmasXDR; shift 1 ;;
                *  )    print -u2 "!!! option $1 incorrecte !!!"
                                exit 1  ;;
        esac
done

[[ -z $compress ]] || suffix=$suffix".gz"

ListeFich=( $@ )

if [[ -z $ListeFich ]]; then
    if [[ -z $binary ]]; then
	ListeFich=( $(ls Splotch?_????_part.asc* 2>/dev/null) )
    else
	ListeFich=( $(ls Splatch*.bin 2>/dev/null) )
    fi
fi

for file in $ListeFich; do
    OOPs_file=${file%.gz}
    OOPs_file=${OOPs_file%.asc}%$suffix
    if [[ -f $OOPs_file ]]; then
	print -u2 "> File $OOPs_file exists; skipped"
    else
	print -u2 "> $file - - - - - > $OOPs_file ..."
	if [[ -z $binary ]]; then
	    gunzip --force --to-stdout < $file > tmp1_$$
	else
	    Bouse2Cheese4 $file
	    xxxxxxx
	fi 
	eval $nbody2xdr tmp1_$$.xdr < tmp1_$$ 
	
	command="nice -$nice_level amas2denssurech -Er $Er -Es $Es ${Ns:+"-Ns"} $Ns ${remove_empty:+"-remove_empty"} ${surf_density:+"-surf_density"} -N $N $other_options tmp1_$$%AMAS.xdr"
	{
	    echo \# $0 ${date} Command used: 
	    echo \# $command 
	    eval $command 
	} |\
	if [[ -n $compress ]]; then
	    gzip --to-stdout 
	else
	    cat
	fi > $OOPs_file
	rm tmp1_$$*
    fi
done
