#!/usr/bin/ksh

# sauvegarde tous les fichiers necessaires pour reprendre une simulation d'amas
# en l'etat actuel. En fait un fichier tare zippe

ListeFichiers=$(ls -1 *_Random *_Ntir *_SuiviRel *Ray_mas.asc *_Lag* *_input*)

NomFichLog=$(ls -t -1 *_Log | head -1)
[[ -f $NomFichLog ]] || {
    print -u2 "!!! Pas de fichier Log !!!"
    exit 1
}
ListeFichiers=$ListeFichiers" "$NomFichLog

NomAmasIn=$(ls -t -1 *_Evol_*.bin | sort | tail -1) 
[[ -f $NomAmasIn ]] || {
    print -u2 "!!! Pas de fichier d'amas !!!"
    exit 4
}
ListeFichiers=$ListeFichiers" "$NomAmasIn

iPasEvolini=${NomAmasIn%.*}
iPasEvolini=${iPasEvolini##*_}

NomTdTIn=$(ls -t -1 *_tdt_* | grep $iPasEvolini".bin" | tail -1) 
[[ -f $NomAmasIn ]] || {
    print -u2 "!!! Pas de fichier t,dt !!!"
    exit 5
}
ListeFichiers=$ListeFichiers" "$NomTdTIn

typeset -Z$(NbCar_iPasEvol_ds_NomFich.sh) iPasEvolini
[[ -z $1 ]] && {
    NomFichTar="SAUV_SIMUL_"$iPasEvolini".tar"
} || {
    NomFichTar=$1".tar"
} 
tar -cvf $NomFichTar $ListeFichiers &&
gzip $NomFichTar &&
print -u2 ">> Fichier "$NomFichTar".gz cree"


