#! /bin/zsh -f
 
# traitement des options sur la ligne de commande
while [[ $1 = -* ]]; do
    case $1 in
        -f | -F | --Forcer) Forcer=1 ; shift 1 ;; # Forcer le calcul si le modele existe deja
        -p | -p | --tostdout ) ToStdOut=1 ; shift 1 ;; # Copie le modele en sortie standard
        *  )
              print -u2 "!!! option $1 illegale !!!"
              exit 1 ;;
    esac
done            

Type=$1
MBH=$2

MBH=$(printf "%3.1e" $MBH)
RepBase=~/AMAS/adiab/pycode/runs
Exe=~/AMAS/adiab/pycode/code/pyoung

cd $RepBase

[[ -d $Type ]] || {
    print -u2 "!!! $0 : Modele $Type inconnu !!!"
    exit 1
}

cd $Type

if [[ -f MBH_$MBH/PYOUT.end ]]; then
    print -u2 " > $0 : le modele $Type avec MBH = $MBH a deja ete calcule "
    [[ -n $Forcer ]] && rm -f MBH_$MBH/*
else
    [[ -d MBH_$MBH ]] || mkdir MBH_$MBH
fi
cd MBH_$MBH
if [[ ! -f PYOUT.end ]]; then
    cat ../PYDIR.$Type | sed 's/<MBH>/'$MBH'/' > PYDIR
    print -u2 " > $0 : calcul du modele $Type avec MBH = $MBH ..."
    $Exe 1>&2 || {
	print -u2 '!!! > $0 : echec du calcul du modele !!!'
	exit 1
    }
fi

if [[ -n $ToStdOut ]]; then
    print "#  rad      mass     den     sden   sdlgdr   <v**2>   <vp**2>   beta   pkur-3"
    print "# 1:rad  2:mass 3:den 4:sden 5:sdlgdr 6:v2 7:vp2 8:beta 9:pkur3"
    tail -n+2 PYOUT.end
fi
