#!/usr/bin/env python

import sys,subprocess

def run_pipe(pipe_str, infile=None, outfile=None) :
    commands=pipe_str.split('|')
    n_commands=len(commands)
    if n_commands == 1 : # single command
        p=subprocess.Popen(commands[0].split(),stdin=infile,stdout=outfile)
    else :
        p=subprocess.Popen(commands[0].split(),stdin=infile,stdout=subprocess.PIPE)
        for i in range(1,n_commands-1) :
            p_prev = p
            p=subprocess.Popen(commands[i].split(),stdin=p_prev.stdout,stdout=subprocess.PIPE)
            #p.wait()

        p_prev = p
        p=subprocess.Popen(commands[-1].split(),stdin=p_prev.stdout,stdout=outfile)
    p.wait()


if __name__ == '__main__' :

    while 1 :
        sys.stderr.write('\n\nGimme command line \n')
        command=sys.stdin.readline()
        command=command[:-1] # remove trailing "\n"
        run_pipe(command,outfile=sys.stdout)

