#!/usr/bin/zsh

# Remove all files from an "EvolAmas" simulation directory... 
# All? No! One keeps what is needed to start the simulation anew!

ListToKeep=( _EvolAmas%0000000000%AMAS.xdr _EvolAmas%0000000000%ETOILES.xdr _EvolAmas%0000000000%TN.xdr _in gere_evolamas.pl MassRadiusMS.asc Grille_ResColl_SPH.asc  _EvolAmas%%FracRayLag.asc  _EvolAmas%%Mbins.asc  _EvolAmas%%FracSegrLag.asc evolamas  input_EvolAmas )

[[ -f _EvolAmas%0000000000%AMAS.xdr ]] || {
    print -u2 "!!! This doesn't seem to be a simulation directory (no _EvolAmas%0000000000%AMAS.xdr file) !!!"
    exit 1
}

[[ -d _to_remove_ ]] && {
    print -u2 "!!! Directory _to_remove_ already exists !!!"
    exit 1
}
mkdir _to_remove_

[[ -d _to_keep_ ]] && {
    print -u2 "!!! Directory _to_keep_ already exists !!!"
    exit 1
}
mkdir _to_keep_

for file in $ListToKeep; do
    [[ -f $file ]]  && mv $file _to_keep_
done

for file in $(ls -l | gawk '/^[^d]/ {print $9}'); do
    [[ -f $file ]]  && mv $file _to_remove_
done

mv _to_keep_/* .
rmdir _to_keep_



