#!/bin/zsh

# remove *.xdr files from a list of directories, which have no corresponding *AMAS.xdr file

RepList=( "$@" )
RepBase=$(pwd)

[[ -z $RepList ]] && RepList=( "." )

for rep in $RepList; do
    cd $rep
    List=( $(ls *.xdr | grep -v -E '(PG|GRILLE)\.xdr') )
    for file in $List; do
	Amas_file=${file%""%*}%AMAS.xdr
	[[ -f $Amas_file ]] || {
	    print -u2 '> removing' $rep/$file
	    rm $file 
	}
    done
    cd $RepBase
done
