#!/bin/zsh

# attempt at removing the sections of *.asc files is simulation directory
# corresponding to a "flash-back", i.e. a restart of the simulation
# at a smaller step number (i.e. time)

# Deal with *%%Log.asc

file=$(ls -t *%%Log.asc | head -n1 | sed 's/ //g')

if [[ -z $file ]]; then
    print -u2 " No file of type $file_type"
else
    print -u2 " Dealing with $file"

    mv $file $file.BAK || {
	print "!!! cannot backup $file !!!"
	exit 1
    }

    cat $file.BAK | gawk 'BEGIN{max=-1}
	/^\|\=>/ {
	    step=$4
	    if (step>max) {max=step}
	}
	step>=max {print}
    '  > $file
fi

# Deal with *%%CollExcept.asc

file=$(ls -t *%%CollExcept.asc | head -n1 | sed 's/ //g')

if [[ -z $file ]]; then
    print -u2 " No file of type $file_type"
else
    print -u2 " Dealing with $file"

    mv $file $file.BAK || {
	print "!!! cannot backup $file !!!"
	exit 1
    }

    cat $file.BAK | gawk 'BEGIN{max=-1}
	/^\= iPas_evol/ {
	    step=$NF
	    if (step>max) {max=step}
	}
	step>=max {print}
    '  > $file
fi

# Deal with files that have one record per line

for file_type in AniLag CaptGW Coll Evap LC MSpec MbinRad RayLag Segr StEvol SuiviMS SuiviRG SuiviWD SuiviNS SuiviBH Tscale; do
    file=$(ls -t *%%$file_type.asc | head -n1 | sed 's/ //g')
    if [[ -z $file ]]; then
	print -u2 " No file of type $file_type"
    else
	print -u2 " Dealing with $file"
	
	mv $file $file.BAK || {
	    print "!!! cannot backup $file !!!"
	    exit 1
	}
	cat $file.BAK | gawk '
	    /^#/ {print}
	    /^[^#]/ {
		if ($1>max) {print; max=$1}
	    }
	' > $file
    fi
done
