#!/bin/zsh

DirList=( $@ )

base_dir=$(pwd)

for Dir in $DirList; do
    cd $Dir
    StellEvol=$(gunzip -f --to-stdout CaracCode.asc(|.gz) | grep '^ *_EVOL_STELL_ *:' | cut -d ":" -f 2 | sed 's/ //g')
    if (( StellEvol == 0 )); then
	echo $Dir has no stell evol.
	if [[ -f _EvolAmas%0000000000%ETOILES.xdr ]]; then
	    reduce_identical_ETOILES.sh && rm *ETOILES.xdr.BAK && gzip -v _EvolAmas%0000000000%ETOILES.xdr
	else
	    reduce_identical_ETOILES.sh && rm *ETOILES.xdr.gz.BAK
	fi
    else
	echo $Dir has stell evol.
	gzip -v *ETOILES.xdr
    fi
    cd $base_dir
done
