#! /usr/local/bin/zsh -f

# Cherche a rapporter (sous forme de donnees .xdr de nom de base $3)
# Le modele d'amas $2 de la simulation $1 sur gravitor
# On prend egalement les donnees stellaires et de temps

tmp1=/tmp/tmp1_$$

if [[ $1 == -fp ]]; then
    FichParam=$2
    shift 2
fi

NumSim=$2
NomSim=$1
NomBaseRecup=$3
[[ -z $NomBaseRecup ]] && NomBaseRecup=$NomSim"%"$NumSim

rsh obsp400 'ls -1 AMAS/evols/'$NomSim'/*AMAS.xdr' | sort > $tmp1

NbSims=$(wc -l < $tmp1 | sed 's/ //g')
print -u2 "> Le Nb total de sauvegardes pour $NomSim est $NbSims"
if (( NumSim > NbSims )); then
    print -u2 "> On prend la derniere sauvegarde de $NomSim !!!"
    NumSim=$NbSims
fi
NomBase=$(cat $tmp1 | head -n$NumSim | tail -n1)
NomBase=${NomBase%AMAS.xdr}
NomBase=${NomBase##*/}
print -u2 "> On recupere la sauvegarde $NomBase"
iPasSauv=$NomBase
iPasSauv=${iPasSauv#*%}
iPasSauv=${iPasSauv%"%"}
iPasSauv=$(( iPasSauv + 0 ))

if [[ -n $FichParam ]]; then
    {
	print "# 1: NumSauv 2: NbSauvs 3: iPasSauv"
	print $NumSim $NbSims $iPasSauv
    } > $FichParam
fi

# Fichier d'amas
print -u2 "> Fichier d'amas :>  "$NomBaseRecup"_AMAS.xdr"
rcp -p obsp400:AMAS/evols/$NomSim/$NomBase""AMAS.xdr $NomBaseRecup""_AMAS.xdr

# Fichier d'etoiles
print -u2 "> Fichier d'etoiles :>  "$NomBaseRecup"_ETOILES.xdr"
rcp -p obsp400:AMAS/evols/$NomSim/$NomBase""ETOILES.xdr $NomBaseRecup""_ETOILES.xdr

# Fichier de temps
print -u2 "> Fichier de temps :>  "$NomBaseRecup"_TEMPS.xdr"
rcp -p obsp400:AMAS/evols/$NomSim/$NomBase""TEMPS.xdr $NomBaseRecup""_TEMPS.xdr

rm $tmp1