#! /usr/local/bin/zsh -f

# Cherche a rapporter (sous forme de donnees /rdb ecrites en stdout)
# Le modele d'amas $2 de la simulation $1 sur gravitor
# On prend egalement les donnees stellaires et de temps

tmp1=/tmp/tmp1_$$

if [[ $1 == -fp ]]; then
    FichParam=$2
    shift 2
fi

NumSim=$2
NomSim=$1

rsh obsp400 'ls -1 AMAS/evols/'$NomSim'/*AMAS.xdr' | sort > $tmp1

NbSims=$(wc -l < $tmp1 | sed 's/ //g')
print -u2 "> Le Nb total de sauvegardes pour $NomSim est $NbSims"
if (( NumSim > NbSims )); then
    print -u2 "> On prend la derniere sauvegarde de $NomSim !!!"
    NumSim=$NbSims
fi
NomBase=$(cat $tmp1 | head -n$NumSim | tail -n1)
NomBase=${NomBase%AMAS.xdr}
NomBase=${NomBase##*/}
print -u2 "> On recupere la sauvegarde $NomBase"
iPasSauv=$NomBase
iPasSauv=${iPasSauv#*%}
iPasSauv=${iPasSauv%"%"}
iPasSauv=$(( iPasSauv + 0 ))

if [[ -n $FichParam ]]; then
    {
	print "# 1: NumSauv 2: NbSauvs 3: iPasSauv"
	print $NumSim $NbSims $iPasSauv
    } > $FichParam
fi

# Fichier d'amas
print -u2 "> Fichier d'amas"
rcp -p obsp400:AMAS/evols/$NomSim/$NomBase""AMAS.xdr /tmp/_tmp_$$_AMAS.xdr 2> /dev/null && \
amas_xdr2rdb /tmp/_tmp_$$_AMAS.xdr > /tmp/_tmp_$$_AMAS.rdb

# Fichier d'etoiles
print -u2 "> Fichier d'etoiles"
rcp -p obsp400:AMAS/evols/$NomSim/$NomBase""ETOILES.xdr /tmp/_tmp_$$_ETOILES.xdr 2> /dev/null && \
etoiles_xdr2rdb /tmp/_tmp_$$_ETOILES.xdr > /tmp/_tmp_$$_ETOILES.rdb

# Fichier de temps
print -u2 "> Fichier de temps"
rcp -p obsp400:AMAS/evols/$NomSim/$NomBase""TEMPS.xdr /tmp/_tmp_$$_TEMPS.xdr 2> /dev/null && \
temps_xdr2rdb /tmp/_tmp_$$_TEMPS.xdr > /tmp/_tmp_$$_TEMPS.rdb

if [[ -f /tmp/_tmp_$$_AMAS.rdb ]]; then
    cat /tmp/_tmp_$$_AMAS.rdb |\
	if [[ -f /tmp/_tmp_$$_ETOILES.rdb ]]; then
	    paste.rdb - /tmp/_tmp_$$_ETOILES.rdb
	else
	    cat
	fi |\
	if [[ -f /tmp/_tmp_$$_TEMPS.rdb ]]; then
	    paste.rdb - /tmp/_tmp_$$_TEMPS.rdb
	else
	    cat
	fi |\
	rmblank
else
    print -u2 "!!! Impossible de recuperer /$NomBase""ETOILES.xdr !!!"
    exit 1
fi

rm /tmp/_tmp_$$_*
rm $tmp1