#!/usr/bin/ksh 

# Va chercher un modele initial d'amas de nom $1 dans le repertoire des modeles et le 
# place dans le repertoire courant avec le nom de base $2 ("_EvolAmas" par defaut)

if [[ $1 = "-l" ]]; then
    shift 1
    lien=1
fi

NomModele=$1
BaseNameTarget=${2:-"_EvolAmas"}
RepModeles=~/AMAS/Modeles/
DirInputFiles=~/AMAS/codes/MESSY/share/parameter_files/standard_set/
DirSources=~/AMAS/codes/MESSY/current/

NomFich=$RepModeles""$NomModele

Ext=$( echo $NomFich | sed 's/^[^.]*//; s/^\.//' )

[[ -z $Ext ]] && Ext="xdr"
BaseNameSource=${NomFich%%.*}
BaseNameSource=${BaseNameSource%_AMAS}

# on affiche le fichier doc, si il existe
FichDoc=${NomFich%.*}".doc"
[[ -f $FichDoc ]] || FichDoc=${NomFich%_*}".doc"
[[ -f $FichDoc ]] && {
    print " CONTENT OF FILE .doc : "
    print "========================"
    cat $FichDoc
    print "========================"
}

FichSource=${NomFich%%.*}.$Ext
FichCible=./InitStruct_AMAS.$Ext
Lien=./$BaseNameTarget"%0000000000%AMAS."$Ext
[[ -f $FichSource ]] || {
    print -u2 "!!! File $FichSource not found !!!"
    FichSource=${NomFich%%.*}_AMAS.$Ext
    [[ -f $FichSource ]] || {
	print -u2 "!!! File $FichSource not found !!!"
	exit 1
    }
}

[[ -f $FichCible ]] && {
    chmod u+w $FichCible
    rm $FichCible
}
if [[ -z ${lien:-1} ]] ; then
    cp -v $FichSource $FichCible
    chmod u-w $FichCible
else
    ln -sv $FichSource $FichCible
fi
ln -s $FichCible $Lien


for Type in "ETOILES" "MAREE" "TN" "TEMPS" "LIMEXT"; do
    FichSource=$BaseNameSource"_"$Type"."$Ext
    FichCible=./InitStruct_$Type.$Ext
    Lien=./$BaseNameTarget"%0000000000%"$Type"."$Ext
    [[ ! -f $FichSource ]] || {
	[[ -f $FichCible ]] && {
	    chmod u+w $FichCible
	    rm $FichCible
	}
	if [[ -z ${lien:-1} ]] ; then
	    cp -v $FichSource $FichCible
	    chmod u-w $FichCible
	else
	    ln -sv $FichSource $FichCible
	fi
        ln -s $FichCible $Lien
    }
done


if [[ ! -f input_EvolAmas ]]; then
    print -u2 "> No file input_EvolAmas, getting example file"
    cp $DirSources/input_EvolAmas.exple input_EvolAmas
fi 

FichSource=$BaseNameSource"_input_EvolAmas"
[[ -f $FichSource ]] || FichSource=${NomFich%_*}"_input_EvolAmas"
if [[ -f $FichSource ]]; then
    print -u2 "> Adding data from ${FichSource##*/} to input_EvolAmas"
    mv input_EvolAmas input_EvolAmas.BAK
    cat input_EvolAmas.BAK $FichSource >  input_EvolAmas
fi
    
# Standard set of parameter files (mostly optional)
for file in $DirInputFiles/*.asc; do
    local_file=${file##*/}
    if [[ ! -f $local_file ]]; then
	 print -u2 "> No file $local_file, getting standard file ($file)"
	 cp $file .
    fi
done


if [[ ! -f gere_evolamas.pl ]]; then
    print -u2 "> Getting script gere_evolamas.pl"
    cp ~/AMAS/util/gere_evolamas.pl .
fi 
