#!/usr/bin/zsh

while [[ $1 = -* ]]; do
    case $1 in

        -nbody ) nbody=$2; shift 2;;
        *      )
              print -u2 "!!! What exactly do you mean with $1, you magnificient weirdo? !!!"
              exit 1 ;;
    esac
done

source ~/AMAS/Nemo/nemo_start.sh

grep -v '^ *#' |\
    if [[ -z $nbody ]]; then
       cat > /tmp/tmp_$$
       tabtos in="/tmp/tmp_$$" out=- block1="mass,pos" 
    else
       tabtos in=- out=- block1="mass,pos" nbody=$nbody
    fi |\
snapcenter in=- out=- |\
snapsort in=- out="/tmp/tmp2_$$" rank="x*x+y*y+z*z"

hackdens in="/tmp/tmp2_$$" out=-  write_at_phi=t |\
snapprint in=- format="%12.5e" options="phi" 

[[ -f /tmp/tmp_$$ ]] && rm /tmp/tmp_$$
[[ -f /tmp/tmp2_$$ ]] && rm /tmp/tmp2_$$
