#!/usr/bin/env python

"""Merge particles that are at the same position or very close to each other
   the first 7 columns of the ascii file must be 'm x y z vx vy vz'
   """

import getopt, sys

from numpy import *
from pylab import load
import Nbody_Utils


def usage():
    print "usage : " + sys.argv[0] + " [--eps_merg eps_value] nbody_snapshot.asc(.gz)"

def list2str(my_list) : # To print short list in a compact, space-less way
    if len(my_list)==0 :
        return ''
    else :
        i=0
        my_str=str(my_list[i])
        for i in range(1,len(my_list)) :
            my_str+=','+str(my_list[i])
    return my_str
    
def main():
    # Command-line arguments
    try:
        opts, args = getopt.getopt(sys.argv[1:], "e:", ["eps_merg="])
    except getopt.GetoptError:
        # print help information and exit:
        usage()
        sys.exit(2)
        
    eps_merg=0.0
    for o, a in opts:
        if o in ("-e", "--eps_merg"):
            eps_merg = float(a)
            sys.stderr.write(
                '>> Value of eps_merg set to %12.5e\n' % eps_merg
                )
    # ...
    
    # Open file and read all particles

    sys.stderr.write('>> Reading data ...')
    try:
        #data = load(args[0]) # much faster than read_array!
        m,x,y,z,vx,vy,vz = load(args[0], usecols=(0,1,2,3,4,5,6), unpack=True)
    except:
        # print help information and exit:
        usage()
        sys.exit(2)

    
    sys.stderr.write(' done. %i particles\n' % len(m))

    # Merging if required
    m,x,y,z,vx,vy,vz,iorigin = Nbody_Utils.merge_same_pos(m,x,y,z,vx,vy,vz,eps_merg,verb=1)
    print '>> ', len(m),len(x),len(iorigin)
    exit
    Npost_mrg=len(m)
    
    # Print the results
    sys.stderr.write('>> Writing ...')
    
    ipart=0
    while ipart<Npost_mrg :
        sys.stdout.write( '%14.7e %14.7e %14.7e %14.7e %14.7e %14.7e %14.7e %s\n' %
                          (m[ipart],
                           x[ipart],y[ipart],z[ipart],
                           vx[ipart],vy[ipart],vz[ipart],
                           list2str(iorigin[ipart])))
        ipart+=1

    sys.stderr.write(' done.')
    
if __name__ == "__main__":
    main()
