#!/usr/bin/ksh

# Nom : lance_evolamas.sh
# ###########################

# BUT        :	interface au programme d'evolution d'amas
# ===========  	formatte le fichier de parametres proprement
#               Version 2 traitant de maniere plus propre l'effacement
#               d'une partie des sauvegardes pour decharger le disque ("eclaircissement")
#	
# Appelle    :	
# -----------	

# fonction appelee a la sortie du script

#% affiche le script si de l'aide est demandee
if [[ $1 = "--help" ]]; then
        less $0
        exit
fi
#%

function f_Sortie {
	trap  "" EXIT # pour etre sur que les operations qui suivent seront faites coute que coute
	print -u2 "...Sortie de $NomScript..."
	EnCours=""
	cat > _stop_.sh <<EOF
#!/usr/bin/ksh
touch _STOP_
EOF
	if [[ ! -z $pid_sim ]] && $_ps_ | awk '{print $1}' | grep -q -s "^$pid_sim\$"; then
	    EnCours=="OUI"
	    cat >> _stop_.sh <<EOF
kill -9 $pid_sim   || rsh $(hostname) kill -9 $pid_sim
EOF
	fi
	if [[ ! -z $pid_Eclai ]] && $_ps_ | awk '{print $1}' | grep -q -s "^$pid_Eclai\$"; then
	    EnCours=="OUI"
	    cat >> _stop_.sh <<EOF
kill -9 $pid_Eclai   || rsh $(hostname) kill -9 $pid_Eclai
EOF
	fi
	if [[ -z $EnCours ]]; then
	    rm _stop_.sh
	else
	    chmod a+x _stop_.sh
	    print -u2 " !!! SIMULATION EN COURS !!!"
	    print -u2 " interrompre avec _stop_.sh"
	fi
        rm 'tmp'?'_'$NomScript'_'$PIDScript'_tmp'?
        print -u2 $ligne_hier"====< script $NomScript termine"
}

export ligne_hier=$ligne_hier"= "
NomScript=${0##*/}
PIDScript=$$
print -u2 $ligne_hier"====> script $NomScript"
trap  "f_Sortie" EXIT

# fichiers provisoires

tmp1=tmp1'_'$NomScript'_'$PIDScript'_'tmp1
tmp2=tmp2'_'$NomScript'_'$PIDScript'_'tmp2
touch $tmp1
#......................................................................

# specificites liees au differentes plateformes
if [[ $OSTYPE = "solaris" ]]; then
    _ps_="/usr/ucb/ps x"
elif [[ $OSTYPE = "linux" ]] || [[ $OSTYPE = "linux-gnu" ]]; then
    _ps_="/bin/ps x"
else
    print -u2 "!!! Plateforme $OSTYPE non reconnue !!!"
    exit 1
fi


function f_Param_Cont {	# determine les parametres permettant de continuer
			# une simulation commence dans le repertoire courant
	# il suffit en fait de determiner le nom de la simulation et le numero
	# de la derniere sauvegarde
	DerSauv=$(ls -1 *%AMAS.@(bin|xdr) | grep -v "^_RIP" | sort | sed -n '$p') # derniere sauvegarde
	NomSimul=${DerSauv%%\%*}
	i_ini=${DerSauv%\%*}
	i_ini=${i_ini#*\%}
	ListeOpt=$ListeOpt"NomSimul\n   $NomSimul\ni_ini\n   $i_ini\n"
}

function f_info {
	texte="<$(date)> $@"
	print -u2 "$texte"
	print "$texte" >> "evolamas_PROC"
}

function f_comp { # comprime les fichiers de sauvegarde au fur et a mesure de leur production
		  # laisse le dernier fichier non compresse
	until [[ -f _STOP_ ]]; do
		liste=$( ls -1 -t *_Evol_*.bin *_Evol_*.xdr 2>/dev/null | tail +2)
		[[ -z $liste ]] || gzip $liste
		sleep 30
	done
} 

function f_Eclai { # "eclaircit" le repertoire en effacant une fraction Frac_Eclai
	           # des fichiers de sauvegarde
    t_sleep=300 # 5 minutes entre 2 nettoyages
    until [[ -f _STOP_ ]]; do
	ListeFichEfface=$(
	    ~/AMAS/sh/determine_svg_a_effacer.sh $Frac_Eclai 2>/dev/null
	)
	[[ -z $ListeFichEfface ]] || {
	    print -u2 ">> f_Eclai > Effacement des fichiers de sauvegarde : $ListeFichEfface"
	    rm $ListeFichEfface
	}
	sleep $t_sleep
    done
}

#......................................................................

NomExe=evolamas # nom de l'executable : code d'evolution d'amas
FichBlaBla=evolamas.blabla # fichier ou sont envoyes la sortie standard 
                           # et les messages d'erreur de l'executable
Pref=""
Suf=""

# lecture des options sur la ligne de commande

ListeOpt=""
Demarre=0
Lance=1
SeTaire=0
Frac_Eclai=""

while [[ $1 = -* ]]; do
	case $1 in
		-C )	f_Param_Cont || exit 1	# pour continuer la simul entammee dans
			Demarre=1		# le repertoire courant
			Continue=1
			shift 1		;;	
		-F )	Demarre=1		# force le demarrage meme si il y a deja des
			shift 1		;;	# des fichiers d'une simulation entammee
		-X )    NomExe=$2
			shift 2		;;
		-P )	Lance=0 		# Ne lance pas la simulation !!
			shift 1		;; 	# ne fait que produire en sortie un fichier
						# d'input correct pour "evolamas"
		-O )  	ListeOpt="$ListeOpt${2%=*}\n   ${2#*=}\n"
			shift 2 	;;
		-S )	FichBlaBla=$2
			shift 2		;;
		-NS )	FichBlaBla=''
			shift 1		;;
		-N )	Pref="nice -"$2
			shift 2		;;
		-T )    SeTaire=1
			shift 1         ;;
		-FE )   Frac_Eclai=$2           # "Eclaircit" le repertoire en effacant une fraction
			shift 2         ;;      # Frac_Eclai des sauvegardes
		*  )  	print -u2 "!!! option $1 incorrecte !!!"
			exit 1		;;
	esac
done

if (( (Demarre == 0) && (Lance == 1) )); then
	if [[ -z $(ls *%Log.asc *%AMAS.bin *%AMAS.xdr 2>/dev/null | grep -v -E "%0{9,}%") ]]; then
		Demarre=1
	else
		print -u2 '!!! Il y a deja une simulation entamee dans ce repertoire !!!'
		print -u2 '!!! employer option -F ou -C                              !!!'
		exit 1
	fi
fi
 
[[ -z $1 ]] || exec < $1 # ainsi le fichier de parametre est en entree standard
{
	sed '/#/s/#.*$//' | perl -p -e "s|\@HOME\@|$HOME|g; s|\011|\012|g;" 
	print $ListeOpt
} | sed '/^ *$/d' > $tmp1

commande="$Pref $NomExe < $tmp1 "${FichBlaBla:+" "${Continue:+">"}"> $FichBlaBla 2>&1"}" &"
f_info "COMMANDE : "$commande

if (( Lance == 1 )); then

	[[ -f _STOP_ ]] && rm _STOP_

	eval $commande
	pid_sim=$!
	f_info "SIMULATION EN COURS (pid $pid_sim)"
	sleep 2

	pid_Eclai=0
	[[ $Frac_Eclai = "" ]] || {
	    f_Eclai &
	    pid_Eclai=$!
	}

	## f_comp &
	(( SeTaire == 0 )) && [[ -f $FichBlaBla ]] && tail -f $FichBlaBla
else
	cat $tmp1
fi

