#! /usr/bin/perl -w

# script pour lancer des simulations Monte Carlo d'amas sur "isis", Berne, 02.02.2001
#
# emploi type : lance_evolamas.pl --continue --repertoire=PC_839 --option i_fin=500000000

use Getopt::Long;
Getopt::Long::Configure("default");


my $executable="evolamas";
my $input_file="input_EvolAmas";
my $autre_repertoire="";
my %defines = ();

# Options sur la ligne de commande

GetOptions(
	   "define=s" => \%defines,
	   "option=s" => \%defines,
	   "O=s"      => \%defines,
	   "continuer|c|C"    => \$continuer,
	   "blanc|a_blanc|B" => \$a_blanc,
	   "forcer|F"        => \$forcer,
	   "executable|X=s"  => \$executable,
	   "input|i=s"       => \$input_file,
	   "repertoire|D=s"  => \$autre_repertoire,
	   "ecrit_input|P"   => \$filtre_input,
	   "random|R"        => \$random,
	   "silencieux|T"    => \$se_taire
	  ) || die;

# on se place dans le bon repertoire

if ($autre_repertoire) { 
  chdir($autre_repertoire) or 
    die("impossible de se deplacer dans $autre_repertoire") 
  };

# Lecture des options du fichier "input_EvolAmas"

my %h_options;
open INPUT, $input_file;
while (<INPUT>) {
  if (/^(\w+)/) { $NomOpt=$1 };
  if (/^\s+([\w\.-]+)/) { $ValOpt=$1; $h_options{$NomOpt}=$ValOpt };
}

# options (re)definies sur la ligne de commande

foreach $NomOpt (keys %defines) {
  $h_options{$NomOpt}=$defines{$NomOpt};
}

# Faut il creer une graine pour le generateur de nb aleatoire?

if ($random) {$h_options{'iRand_Seed'}=-1};

# Determination des valeurs des parametres pour continuer une simulation commencee

if ($continuer) {
  open LISTE, "ls -1 *%AMAS.* | grep -v RIP |";
  $NumMax=-1;
  while (<LISTE>) {
    if (/^(\w+)%([0-9]+)%AMAS.(xdr|bin)$/ && ($2+0 > $NumMax)) {
      $NumMax=$2+0; $NomSimul=$1;
    }
  }
  $h_options{"i_ini"}=$NumMax;
  $h_options{"NomSimul"}=$NomSimul;
}

# Ecriture des options en sortie standard si demande

if ($filtre_input) {
  foreach $NomOpt (sort keys %h_options) {
    print $NomOpt,"\n    ",$h_options{$NomOpt},"\n";
  }
  exit;
}

# Lancement de la simulation
#============================

# Tester que la simulation n'a pas deja ete demarree

if (`ls *%Log.asc 2>/dev/null` and (not ($forcer or $continuer))) {
  print STDERR "!!! Il y a deja une simulation entamee dans ce repertoire !!!\n";
  print STDERR "!!! employer option -F ou -C                              !!!\n";
  die;
}
    
open INPUT_FILE, "> _input_" || die("!!! Impossible d'ouvrir fichier '_input_' !!!");
foreach $NomOpt (sort keys %h_options) {
  print INPUT_FILE $NomOpt,"\n    ",$h_options{$NomOpt},"\n";
}

$Ligne_commande = "$executable -f _input_";
$Ligne_commande = $Ligne_commande . ' > /dev/null 2>&1 ' if ($se_taire);

if (not $a_blanc) {
  system($Ligne_commande)==0 or
    die ("!!! Erreur a l'execution de la commande '$Ligne_commande' !!!");
} else {
  print "Commande a executer : '$Ligne_commande'\n";
}

__END__

 
