#! /bin/zsh -f
cd ~/AMAS/evols/resultats
#host=$1
#shift

source_directory=AMAS/evols/simuls/
source_host="hydra.ari.uni-heidelberg.de"
#source_directory=AMAS/evols

# traitement des options sur la ligne de commande
while [[ $1 = -* ]]; do
    case $1 in
        -t | -T | --Terminee) source_directory=disks/work1/AMAS/evols/simuls/terminees ; shift 1 ;; 
        *  )
              print -u2 "!!! option $1 illegale !!!"
              exit 1 ;;
    esac
done            

Liste=( $@ )

ssh="ssh"
domainname=$(hostname --long)
domainname=${domainname#*.}
[[ -z $domainname ]] && domainname="somewhere.else"
if [[ "$domainname" == "ari.uni-heidelberg.de" ]]; then
    echo "> Direct transfer from $source_host"
    ssh="ssh"
else
    echo "> Using ARI gateway computer"
    ssh="ssh -F /home/freitag/.ssh/ssh_config"
fi

rsync -auvzL --progress --rsh="$ssh"  --exclude "_out" --exclude "_RIP*" --exclude "fort.*" --exclude "*.xdr" --exclude "*.xdr.gz" --exclude "evolamas" --exclude "Grille_ResColl_SPH.asc*" --exclude "*.BAK" freitag@$source_host:$source_directory/RA_\* ~/AMAS/evols/resultats/

