#! /bin/zsh -f
cd ~/AMAS/evols/resultats
#host=$1
#shift

source_host="typhoon.phys.northwestern.edu"
source_directory=/storage/freitag/AMAS/evols/

# traitement des options sur la ligne de commande
while [[ $1 = -* ]]; do
    case $1 in
	-r )    Remote=1 # force remote (out-of-NU) transfer
		source_host="chinook.astro.northwestern.edu"
		source_directory=AMAS/evols/resultats/
		shift 1         ;;
	-l )    Local=1 # force local (NU) transfer
		source_host="typhoon.phys.northwestern.edu"
		source_directory=/storage/freitag/AMAS/evols/
		shift 1         ;;
        *  )
              print -u2 "!!! option $1 illegale !!!"
              exit 1 ;;
    esac
done            

Liste=( $@ )

ssh="ssh"

rsync -auvzL --progress --rsh="$ssh" --exclude "cond_ini/**" --exclude "/*_to*Gyr*/" --exclude "_out" --exclude "_RIP*" --exclude "fort.*" --exclude "*.xdr"  --exclude "*.xdr.gz" --exclude "evolamas" --exclude "Grille_ResColl_SPH.asc" --exclude  "_EvolAmas%%StrongEncounters.asc" --exclude "*.BAK" --exclude "*GRILLE*" --exclude "*Tcarac.asc*" --include "*OOPs.asc*" --exclude "*%?*%*" freitag@$source_host:$source_directory/\[A-Z\]\[A-Z\]\#\[0-9\]\#_\* ~/AMAS/evols/resultats/
