#! /usr/bin/ksh
# cree une table /rdb  "Code Tcc Mcc" pour les simulations decrites dans evols.rdb

cat evols.rdb | grep -v "^#" | row 'Resultat~"Mcc"' |\
column Code Resultat | addcol Tcc Mcc |\
compute '
    match(Resultat,"Tcc *= *[0-9]*\.[0-9]*e[0-9]*");
    Tcc=substr(Resultat,RSTART,RLENGTH);
    sub("Tcc *= *","",Tcc);
    match(Resultat,"Mcc *= *[0-9]*\.[0-9]*e[0-9]*");
    Mcc=substr(Resultat,RSTART,RLENGTH);
    sub("Mcc *= *","",Mcc);
' | column Code Tcc Mcc
