#! /usr/bin/ksh

# Dans un repertoire de simulation d'amas, determine quelle sont les fichiers
# de sauvegarde a detruire. En produit la liste en sortie std.
# Il faut donner en paramettre la fraction de fichier a detruire (entre 0 et 1)
# La premiere et les 2 dernieres sauvegardes sont de toutes facons conservees

Frac_Effac=$1
[[ -z $Frac_Effac ]] && {
    print -u2 "!!! Il faut indiquer la fraction de sauvegardes a efface en parametre !!!"
    exit 1
}

Fichier_input="input_EvolAmas"

[[ -f $Fichier_input ]] || {
    print -u2 "!!! Fichier $Fichier_input absent !!"
    exit 1
}

eval $(
    cat $Fichier_input | sed 's/#..*$//; /^ *$/d; s/^  *//' |\
    gawk '{Var=$1;getline;Val=$1;sub("d","e",Val);sub("D","e",Val);print Var"=\""Val"\""}'
)

# nb de particules
typeset -i NbSE
NbSE=$(nbse.sh $(
	ls -1 $NomSimul""*"AMAS."@(bin|xdr) | head -n1
    )
)
[[ -z $NbSE ]] && {
    print -u2 "!!! Impossible d'obtenir NbSE !!!"
    exit 1
}
print -u2 " > NbSE = $NbSE"

# numero de l'avant-derniere sauvegarde faite
typeset -i iADer
iADer=$(ls -1 $NomSimul""*"AMAS."@(bin|xdr) | sort | tail -n2 | head -n1 | cut -d"%" -f2)
print -u2 " > Numero avant-derniere sauvegarde faite = $iADer"

# production de la liste des sauvegardes que EvolAmas a faites
# (ou aurait du avoir faites)

ListeNumSauvEfface=$(
    gawk -v FacNbPasSauv=$FacNbPasSauv \
         -v NbSE=$NbSE                 \
         -v iADer=$iADer               \
         -v Frac_Effac=$Frac_Effac     \
	'BEGIN{
	    N_efface=0
	    N_tot=0
	    for(i=0;iPas<iADer;i++) {
		iPas=int(i*FacNbPasSauv*NbSE+0.5)
		if (N_efface<Frac_Effac*N_tot && iPas<iADer) {
		    print iPas
		    N_efface++
		}
		N_tot++
	    }
	    exit
	}
    '
)

# liste des fichiers a effacer

typeset -Z$(NbCar_iPasEvol_ds_NomFich.sh) iPas
for iPas in $ListeNumSauvEfface; do
    ls -1 $NomSimul"%"$iPas"%"* 2>/dev/null
done

exit
