#!/bin/zsh

LC_ALL=C
export LC_ALL
setopt EXTENDED_GLOB

DirList=( $@ )

base_dir=$(pwd)

for Dir in $DirList; do
    if [[ -d $Dir ]]; then
	cd $Dir
	unset StellEvol
	file_Carac=$(echo CaracCode.asc(|.gz)(N))
	[[ -z $file_Carac ]] && StellEvol="unknown"
	if [[ -n $file_Carac ]]; then 
	    StellEvol=$(gunzip -f --to-stdout $file_Carac | grep '^ *_EVOL_STELL_ *:' | cut -d ":" -f 2 | sed 's/ //g')
	    [[ -z $StellEvol ]] && StellEvol="unknown"
	fi
	
	if [[ $StellEvol == "0" ]]; then
	    print -u2 "> No stellar evolution for $Dir"
	    Files=( $(ls -1 *%([0-9])##%ETOILES.xdr(|.gz) | sort) )
		if [[ -n $Files ]]; then
		    FirstFile=$Files[1]
		    OtherFiles=( $Files[2,$#Files] )
		       if [[ -f $FirstFile ]]; then
			   [[ -n $OtherFiles ]] && rm $OtherFiles
			   rm  *%([0-9])##%ETOILES.xdr(|.gz)._xdelta_
		       else
			   print -u2 "!!! File $FirstFile doesn't exists in $Dir !!!"
		       fi
		elif [[ -f ETOILES.tar.gz ]]; then
		    FirstFile=$(gunzip --to-stdout ETOILES.tar.gz | tar tvf - | gawk '{print $NF}' | sort | head -1)
		    if [[ -z $FirstFile ]]; then
			print -u2 "!!! Cannot find first file in ETOILES.tar.gz in directory $Dir !!!"
		    else
			if gunzip --to-stdout ETOILES.tar.gz | tar xvf - $FirstFile && [[ -f $FirstFile ]]; then
			    rm ETOILES.tar.gz
			else
			    print -u2 "!!! cat extract $FirstFile from ETOILES.tar.gz in $Dir !!!"
			fi
		    fi
		fi
	else # In this case, tar & gzip
	    print -u2 "> Stellar evolution for $Dir (?)"
	    if [[ ! -f ETOILES.tar.gz ]]; then
		if tar cvf ETOILES.tar *%([0-9])##%ETOILES.xdr(|.gz) && gzip ETOILES.tar; then
		    rm *%([0-9])##%ETOILES.xdr(|.gz)
		else
		    print -u2 "!!! cannot create ETOILES.tar.gz in $Dir !!!"
		fi
	    else
		rm  *%([0-9])##%ETOILES.xdr(|.gz)
		rm  *%([0-9])##%ETOILES.xdr(|.gz)._xdelta_
	    fi
	fi
	cd $base_dir
    fi
done
