#! /bin/zsh

# A partir des fichiers *%%LC.asc et *%%captGW.asc du repertoire $1,
# fait une table /rdb des caracteristiques des captures par emission
# d'ondes grav.

tmp1=/tmp/tmp1_$$

NomRep=$1
[[ -z $NomRep ]] && NomRep="."

catz.sh $NomRep/*%%CaptGW.asc(|.gz) | sortiefort2rdb.sh | monotonise_rdb.sh iPas_Evol > $tmp1

catz.sh $NomRep/*%%LC.asc(|.gz) | sortiefort2rdb.sh | rename Porb_harm Porb_quad | monotonise_rdb.sh iPas_Evol | jointable -n -j iPas_Evol - $tmp1 | addcol Theta_GW | compute 'Theta_GW=sqrt(theta2)' | rmcol Beta_dechir iFlagLC theta2

rm $tmp1
