#! /bin/zsh -f
# usage typique 'creer_modele_MCD91.sh -N 1000000 2 B'

Nb_SE=256000
pd="2"
pmf="B"
Age="0"
M_TN_en_Msol=1e4
Mmin=0.258
Mmax=34.8 # valeurs 'optimales' pour obtenir les memes masses stellaires moyennes que MCD91
Gamma_relax=0.4
Gamma_MCD91=0.4

# traitement des options sur la ligne de commande
while [[ $1 = -* ]]; do
    case $1 in
	-g ) Gamma_relax=$2 ; shift 2 ;; 
        -N ) Nb_SE=$2 ; shift 2 ;; 
        -A ) Age=$2 ; shift 2 ;; 
        *  )
              print -u2 "!!! option $1 illegale !!!"
              exit 1 ;;
    esac
done

[[ -n $1 ]] && pd=$1
case $pd in
    1 ) rho_0=7.0e8;;
    2 ) rho_0=7.0e7;;
    3 ) rho_0=7.0e6;;
    4 ) rho_0=7.0e5;;
    * ) print -u2 "!!! Mauvaise valeure du parametre de densite : $pd !!!"
	exit 1 ;;
esac
       
[[ -n $2 ]] &&  pmf=$2
case $pmf in
    A ) x=0.5; Mmoy_MCD91=2.982 ;;
    B ) x=1.5; Mmoy_MCD91=0.707 ;;
    C ) x=2.5; Mmoy_MCD91=0.431 ;;
    * ) print -u2 "!!! Mauvaise valeure du parametre de f des masses : $pmf !!!"
	exit 1 ;;
esac

a_mf=$( gawk 'BEGIN{print '$x'+1;exit}' )

code_N=$(formatter_milliers.sh $Nb_SE)
NomBase="MCD91_"$pd$pmf"_"$code_N

cd ~/AMAS/Modeles

# Creation du fichier d'amas de base
Fich=plummer_$code_N.xdr

if [[ ! -f $Fich ]]; then
    print -u2 "> Creation du fichier $Fich"
    echo $Nb_SE\\n$Fich\\n1\\n | creer_plummer > /dev/null 2>&1
    rm ${Fich%.xdr}_MAREE.xdr ${Fich%.xdr}.info ${Fich%.xdr}.tab
fi

# Application du spectre de masse
Fich2="MCD91_"$pmf"_"$code_N

if [[ ! -f $Fich2.xdr ]] || [[ ! -f $Fich2""_ETOILES.xdr ]]; then
    print -u2 "> Creation du spectre de masses..."
    print -u2 "  Creation des fichiers $Fich2.xdr et $Fich2""_ETOILES.xdr"
    appliquerfm3 -age $Age -m "$Mmin,$Mmax" -a "$a_mf" $Fich $Fich2.xdr > $Fich2.log 2>&1
fi
ln -v -sf $Fich2.xdr $NomBase.xdr
ln -v -sf $Fich2""_ETOILES.xdr $NomBase""_ETOILES.xdr

Mmoy=$( etoiles_xdr2mmoy $Fich2""_ETOILES.xdr | gawk '/Masse stellaire/ {print $NF}' )
Mmoy_theo=$( gawk -v Mmin=$Mmin -v Mmax=$Mmax -v alpha=$a_mf 'BEGIN{mu=Mmin/Mmax; Mmoy=Mmin*(alpha-1)/(alpha-2)*(1-mu^(alpha-2))/(1-mu^(alpha-1)); print Mmoy; exit}' )
TailleAmas_en_pc=2.40 # sous reserve (Rcore=1pc)
Mtot=$( gawk 'BEGIN{print 0.85675*'$rho_0'*'$TailleAmas_en_pc'**3;exit}' )
rNbEtoiles=$( gawk 'BEGIN{print '$Mtot'/'$Mmoy';exit}' )
M_TN=$( gawk 'BEGIN{print '$M_TN_en_Msol'/'$Mtot';exit}' )

# Creation du fichier d'input
print -u2 "> Creation du fichier $NomBase""_input_EvolAmas"
cat > $NomBase""_input_EvolAmas <<EOF 
# Grandeurs pour modele de noyau selon Murphy Cohn & Durisen 91 (ApJ 370, 60)
# Pour fichier $NomBase.xdr et $NomBase""_ETOILES.xdr
# TYPE: $pd$pmf 
# Masse stellaire totale: $Mtot Msun    densite centrale: $rho_0 Msun/pc^3
# Spectre de masse alpha=$a_mf entre $Mmin et $Mmax Msun (masse moyenne effective: $Mmoy Msun)
# Masse moyenne d'une particule: $( gawk 'BEGIN{print '$Mtot'/'$Nb_SE';exit}' ) Msun
  
MasseEtoileDef       # Masse de chaque etoile en masse solaire (par defaut)
    $Mmoy  # Valeur de MCD91: $Mmoy_MCD91 Valeur theorique: $Mmoy_theo
 
rNbEtoiles           # Nb (initial) total d'etoiles
    $rNbEtoiles
                   
TailleAmas_en_pc     # "taille" de l'amas en parsec (conversion unite de taille -> pc)
    $TailleAmas_en_pc  # Rcore=1pc
            
M_TN_ini_def         # Masse initiale du TN 
    $M_TN  # M_TN=$M_TN_en_Msol Msun

effic_conv_lum       # efficacite de la conversion de masse en energie lors de l'accretion
    0.1d0  # Valeur par defaut : 0.1d0   

Gamma_relax          # Le coefficient de proportionalite dans le log. coulombien
    $Gamma_relax  # Valeur de MCD91 : $Gamma_MCD91 

EOF
