#!/usr/bin/ksh

# "tar" et compacte les fichiers essentiels du repertoire $1 (evolution d'amas)
# et en fait un fichier $2.tar.gz

Efface="NON"
[[ $1 = "-e" ]] && {
	Efface="OUI"
	shift 1
}

NomRep=$1
NomFich=${2:-$NomRep}

ListeFich=$(
	ls -1 $NomRep/*.asc $NomRep/*bla $NomRep/in*
) 
Num=$(
	ls -1rt $NomRep/*%AMAS.@(bin|xdr) | grep -v "RIP" | tail -1 | cut -d"%" -f2
)
ListeFich=$ListeFich" "$(ls -1 "$NomRep"/*"$Num"*)
Num=$(
	ls -1rt $NomRep/*%AMAS.@(bin|xdr) | head -1 | cut -d"%" -f2
)
ListeFich=$ListeFich" "$(ls -1 "$NomRep"/*"$Num"*)

print "Liste des fichiers sauvegardes :"
print "================================"
#print $ListeFich | tr " " '\012'

tar -cvf $NomFich".tar" $ListeFich
gzip $NomFich".tar"

if [[ $Efface = "OUI" ]]; then
	rm $NomRep/fort.*
	chmod u+w $NomRep/_*
	rm $NomRep/_*
fi
