#!/usr/bin/ksh

# lit un fichier d'evolution de rayons lagrangiens ou les % de masses sont en fct de la masse restante
# et fournit (par interpolation splinoide d'ordre 3) le fichier equivalent ou les % sont definits
# en fonction de la masse totale initiale. 
# Attention : la mention "HORS_LIMITES" apparait quand l'interpolation est impossible (pour les rayons
# lagrangiens les plus exterieurs)

tmp1=tmp1_$$
tmp2=tmp2_$$
tmp3=tmp3_$$
tmp4=tmp4_$$

sed 's/   */ /g' > $tmp1

# ecriture en-tete
cat $tmp1 | grep '^#'

# la liste des % de masse correspondant aux rayons lagrangiens suivis 
cat $tmp1 | head -n3 | tail -n1 |\
sed 's/^[^(]**(//; s/)[^()]*(/ /g; s/)[^)]*$//' | tr ' ' '\012' > $tmp2

# on traite l'un apres l'autre chaque enregistrement (les rayons lagrangiens
# a un instant donne)
cat $tmp1 | grep -v '^#' |\
while read NbSE_liees M_liee Tps_amas RayLag ; do

    # les valeurs des rayons lagrangiens
    echo $RayLag | tr ' ' '\012' > $tmp3

    # on passe en % de la masse initiale
    cat $tmp2 | gawk -v M=$M_liee '{print $1/M}' | paste - $tmp3 > $tmp4

    # on interpole la valeur des rayons lagrangiens pour ces nouveaux %
    # et on ecrit la ligne de donnees interpolees
    {
	print $NbSE_liees $M_liee $Tps_amas' '
	cat $tmp2 | interp_lin $tmp4 | gawk '{print $2}' 
    } | tr '\012' ' '
    print
done |\
sed 's/  *$//'

rm $tmp1 $tmp2 $tmp3 $tmp4
