#!/usr/bin/ksh

# Nom : hier_arbre.sh
# ###########################

# BUT        : 	forme une table /rdb representant un arbre binaire
# ===========  	(avec les niveaux hierarchiques) a partir d'un tableau
#		ASCII d'arbre binaire au format "Ecrire_Arbre_Amas_Asc"
#
# Appele par : 	
# -----------	
#
# Appelle    :	hier_arbre
# -----------	

# fonction appelee a la sortie du script

function f_Sortie {
        rm 'tmp'?'_'$NomScript'_'$PIDScript'_tmp'?
        print -u2 $ligne_hier"====< script $NomScript termine"
}

export ligne_hier=$ligne_hier"= "
NomScript=${0##*/}
PIDScript=$$
print -u2 $ligne_hier"====> script $NomScript"
trap  "f_Sortie" EXIT

# fichiers provisoires

tmp1=tmp1'_'$NomScript'_'$PIDScript'_'tmp1
tmp2=tmp2'_'$NomScript'_'$PIDScript'_'tmp2
touch $tmp1 $tmp2

#......................................................................


function f_arbre2rdb { # transforme les tableaux d'arbre en tables /rdb
	cut -d"#" -f1 | grep -v '^ *$' |\
	sed 's/^\|//; s/  *//g; s/\|$//' | tr '|' '\011'	
}

[[ -z $1 ]] || exec < $1 # le fichier ascii de structure d'arbre

# on forme la table /rdb de niveaux hierarchiques
tee $tmp1 | hier_arbre | f_arbre2rdb | sorttable -n iNoeud > $tmp2

cat $tmp1 | f_arbre2rdb |  sorttable -n iNoeud 	|\
jointable -a1 -n -j1 iNoeud -j2 iNoeud - $tmp2
