#! /bin/zsh -f

# Applique une IMF 'top-heavy' extreme consistante avec les obs. de Figer et al. (99, ApJ 525, 750)
# avec age $2 (en yrs)
# au fichier d'amas $1 pour en faire $1_XTH
# La partie low-mass (M<8) de l'IMF est compatible avec Kroupa (2000, 2002)

FichIn=$1
Age=${2:-"0"}
Tsf=${3:-"0"}

test.sh "$Age > 0" && Evol="_evol" || Evol=""
test.sh "$Tsf > 0" && XSF="_xsf" || XSF=""
FichOut=${FichIn%".xdr"}"_XTH"$Evol$XSF".xdr"
FichLog=${FichIn%".xdr"}"_XTH"$Evol$XSF".log"

print -u2  $FichIn "--> "$FichOut

appliquerfm3 -age $Age -Tsf $Tsf -m "0.01,0.08,0.5,120" -a "0.3,1.3,1.65" $FichIn $FichOut 2>&1 | tee $FichLog
#appliquerfm3 -age $Age -Tsf $Tsf -m "0.01,0.08,0.5,120" -a "0.3,1.3,1.6" $FichIn $FichOut 2>&1 | tee $FichLog