#! /bin/zsh -f

# applique une IMF de type Salpeter avec age $2 (
# au fichier d'amas $1 pour en faire $1_Slpt

exec=appliquerfm3
suff=""
iseed=5637
Mmin=0.2
Mmax=120

# traitement des options sur la ligne de commande
while [[ $1 = -* ]]; do
    case $1 in
	-Mmin ) Mmin=$2;
	     shift 2;;
	-Mmax ) Mmax=$2;
	     shift 2;;
	-suff ) suff=$suff""$2;
	     shift 2;;
        -iseed ) iseed=$2 ; shift 2 ;;
	-exec ) exec=$2 ; shift 2 ;;
        *  )
              print -u2 "!!! option $1 illegale !!!"
              exit 1 ;;
    esac
done

FichIn=$1
Age=${2:-"0"}
Tsf=${3:-"0"}

test.sh "$Age > 0" && suff=$suff"_evol"
test.sh "$Tsf > 0" && suff=$suff"_xsf"
FichOut=${FichIn%".xdr"}"_Slpt"$suff".xdr"
FichLog=${FichIn%".xdr"}"_Slpt"$suff".log"

print -u2  $FichIn "--> "$FichOut

$exec -iseed $iseed -age $Age -Tsf $Tsf -m "$Mmin,$Mmax" -a "2.35" $FichIn $FichOut 2>&1 | tee $FichLog
