#! /bin/zsh -f

# Evolved MF for work on galactic nuclei with Vicky (Feb 2005)

exec=appliquerfm3
suff=""
iseed=5637
Age=0
Tsf=0

Mzams_max_WD=8.0
Mzams_max_NS=22.0
M_WD=0.6
M_NS=1.4
M_BH=10.0
Ntot=1e6

# traitement des options sur la ligne de commande
while [[ $1 = -* ]]; do
    case $1 in
        -NoRenorm ) no_renorm=1
	     shift 1;;
	-f ) fancy_remn=1
	     exec=appliquerfm3_fancy_remn
	     shift 1;;
	-KB0p02 ) # Data from Chris Belczynski, Z=0.02
             KB_remn=0p02; unset fancy_remn
	     exec=appliquerfm3_fancy_remn_KB05_Z0p02
	     shift 1;;
	-KB0p0001 ) # Data from Chris Belczynski, Z=0.0001
             KB_remn=0p0001; unset fancy_remn
	     exec=appliquerfm3_fancy_remn_KB05_Z0p0001
	     shift 1;;
	-noBH ) noBH = 1; suff=$suff"_noBH"; Mzams_max_NS=1e30; shift 1 ;;
        -Ntot ) Ntot=$2 ; shift 2 ;;
        -iseed ) iseed=$2 ; shift 2 ;;
        -Age   ) Age=$2 ; shift 2 ;;
        -Tsf   ) Tsf=$2 ; shift 2 ;;
        *  )
              print -u2 "!!! option $1 illegale !!!"
              exit 1 ;;
    esac
done

FichIn=$1

#NbSE=$( nbse_xdr $FichIn | sed 's/ //g' )

#test.sh "$Age > 0" && suff=$suff"_evol"
[[ -n $fancy_remn ]] && (( Age > 0 )) && suff=$suff"_fcy"
[[ -n $KB_remn ]] && (( Age > 0 )) && suff=$suff"_KB"$KB_remn
#test.sh "$Tsf > 0" && suff=$suff"_xsf"
BaseName=${FichIn%".xdr"}"_NC08"$suff
FichOut=$BaseName".xdr"
FichLog=$BaseName".log"
FichParamStellEvol=$BaseName"_ParamStellEvol"

[[ -f $FichOut ]] && {
    print -u2 "!!! File $FichOut exists. If you want to overwrite it, I won't be accomplice (dude) !!!"
    exit 1
}

print -u2  $FichIn "--> "$FichOut

# Create new AMAS and ETOILES files
[[ -z $fancy_remn ]] && {
    $exec ${no_renorm:+"-NoRenorm"} -iseed $iseed -age $Age -Tsf $Tsf -m "0.08,0.5,120" -a "1.3,2.3" \
      -Mzams_max_WD $Mzams_max_WD -Mzams_max_NS $Mzams_max_NS -M_WD $M_WD -M_NS $M_NS -M_BH $M_BH \
      $FichIn $FichOut 2>&1 | tee $FichLog
} || {
    $exec ${no_renorm:+"-NoRenorm"} -age $Age -Tsf $Tsf -m "0.08,0.5,120" -a "1.3,2.3" \
      $FichIn $FichOut 2>&1 | tee $FichLog
}

# Write info about stellar evolution parameters in file

cat <<EOF > $FichParamStellEvol

Mzams_max_WD
   $Mzams_max_WD

Mzams_max_NS
   $Mzams_max_NS

M_WD
   $M_WD

M_NS
   $M_NS

M_BH
   $M_BH

EOF

# Write relevant info into *_input_EvolAmas file

old_input_file=${FichIn%".xdr"}"_input_EvolAmas"
new_input_file=$BaseName"_input_EvolAmas"

[[ -f $new_input_file ]] && rm $new_input_file
[[ -f $old_input_file ]] && cat $old_input_file > $new_input_file

AvrgStellMass=$(cat $FichLog | grep 'Masse moyenne' | head -n 1 | sed 's/.*: *//')
[[ -z $AvrgStellMass ]] && {
    print -u2 '!!! $0: cannot determine average stellar mass !!!'
    exit 1
}

cat <<EOF >>$new_input_file
# Parameters written by command "$0 $@"

frac_accr_Coll       # fraction of collision-liberated gas accreted by central BH
    1.0d0   # Valeur par defaut : 1.0d0

frac_accr_Dechir     # fraction of tidal-disruption-liberated gas accreted by central BH
    0.5d0   # Valeur par defaut : 1.0d0

frac_accr_EvolSt     # fraction of stellar-evolution-liberated gas accreted by central BH
    0.0d0   # Valeur par defaut : 1.0d0

Gamma_relax          # Coef in Coulomb log
    0.01d0   # Multi-mass

MasseEtoileDef       # Average stellar mass in Msun
    $AvrgStellMass  # Valeur par defaut : 1.0d0

rNbEtoiles           # Nb (initial) total detoiles
    $Ntot    # Total mass: $(( Ntot*AvrgStellMass ))  Msun

EOF

BH_file=${FichIn%".xdr"}"_TN.xdr"
[[ -f $BH_file ]] && MBH=$( xdr2asc $BH_file | gawk 'OK==1 && /^ / {print $1+0; exit}; /# Variable : M_TN/ {OK=1}')

[[ -n $MBH ]] && cat <<EOF >>$new_input_file
M_TN_ini_def         # Default initial mass of central object
    $MBH   # Valeur par defaut : 0.0d0

EOF

