#!/bin/zsh

# for each *.asc file in the current directory, look whether there is a corresponding .asc.gz
# if so concatene, append the .asc file (without '#' comments) to the content of the .asc.gz file
# remove the original .asc and .asc.gz files in favor to a new .asc

Liste=( $(ls -1 *.asc) )
for File in $Liste; do
    if [[ -f $File.gz ]]; then
	{
	    gunzip -c $File.gz
	    cat $File | grep -v '^ *#'
	} > _qq
	mv $File.gz $File.gz.BAK
	mv $File $File.BAK
	mv _qq $File
    fi
done
