#!/bin/zsh

Er=0.8
Es=-1
N=300
suffix="OOPs.asc"
remove_empty=1
other_options=""
nice_level=19

while [[ $1 = -* ]]; do
        case $1 in
                -Er ) Er=$2; shift 2 ;;
                -Es ) Es=$2; shift 2 ;;
                -N  ) N=$2;  shift 2 ;;
                -Ns ) Ns=$2;  shift 2 ;;
                -Mstar ) other_options="$other_options -Mstar $2"; shift 2 ;;
                -nice ) nice_level=$2; shift 2 ;;
		-z  ) compress=1; shift 1 ;;
                -keep_empty ) unset remove_empty; shift 1 ;;
		-mass_bins  ) other_options="$other_options -mass_bins $2 $3"; shift 3 ;;
                -s|-S|-surf_density ) surf_density=1; suffix="SurfOOPs.asc"; shift 1 ;;
                -f|-use_first_ETOILE_file ) use_first_ETOILES_file=1; shift 1 ;;
		-tal|-Tal|-collab_Tal ) Er=0.8; Es=-1; N=500; other_options="$other_options -mass_bins 1 '0.01,0.5,2.0,1000.0'"; shift 1 ;;
                *  )    print -u2 "!!! option $1 incorrecte !!!"
                                exit 1  ;;
        esac
done

[[ -z $compress ]] || suffix=$suffix".gz"

ListeFich=( $@ )

[[ -z $ListeFich ]] && ListeFich=( $(ls *%*%AMAS.xdr 2>/dev/null) )

[[ -n $use_first_ETOILES_file ]] && gunzip -f --to-stdout $(ls -1 *ETOILES.xdr(|.gz) 2>/dev/null | head -n 1) > _TMP_ETOILES_$$

for file in $ListeFich; do
    OOPs_file=${file%''%AMAS.xdr}%$suffix
    if [[ -f $OOPs_file ]]; then
	print -u2 "> File $OOPs_file exists; skipped"
    else
	ETOILES_File=${file%''%AMAS.xdr}%ETOILES.xdr
        if [[ -n $use_first_ETOILES_file ]]; then
	    [[ -f $ETOILES_File ]] && mv $ETOILES_File._SVG_
	    ln -s _TMP_ETOILES_$$ $ETOILES_File
        else
	    if [[ ! -f $ETOILES_File ]] && [[ -f $ETOILES_File.gz ]]; then
		gunzip --to-stdout $ETOILES_File.gz > $ETOILES_File
		compressed_ETOILES=1
	    else
		unset compressed_ETOILES
	    fi
	fi
	print -u2 "> $file - - - - - > $OOPs_file ..."
	command="nice -$nice_level amas2denssurech -Er $Er -Es $Es ${Ns:+"-Ns"} $Ns ${remove_empty:+"-remove_empty"} ${surf_density:+"-surf_density"} -N $N $other_options $file"
	if [[ -f $file ]]; then
	    {
		echo \# $0 ${date} Command used: 
		echo \# $command 
		eval $command 
	    } |\
	    if [[ -n $compress ]]; then
		gzip --to-stdout 
	    else
		cat
	    fi > $OOPs_file
	fi
	
        if [[ -n $use_first_ETOILES_file ]]; then
	    [[ -f $ETOILES_File._SVG_ ]] && rm $ETOILES_File && mv $ETOILES_File._SVG_ $ETOILES_File
	fi
        if [[ -n $compressed_ETOILES ]] && [[ -f ${file%''%AMAS.xdr}%ETOILES.xdr.gz ]]; then
	    rm ${file%''%AMAS.xdr}%ETOILES.xdr
	    unset compressed_ETOILES
        fi
    fi
done

[[ -n $use_first_ETOILES_file ]] && rm _TMP_ETOILES_$$