#!/usr/bin/python

import sys, xdrlib

from array import *

if len(sys.argv)==1:
    print >> sys.stderr, "Are you joking? I need a file name to work!"
    sys.exit(1)

FileName = sys.argv[-1] # last argument on command line should be file name


types={
    '_i_':'integer', '_ti_':'integer',
    '_r_':'real*4', '_tr_':'real*4',
    '_d_':'real*8', '_td_':'real*8',
    '_s_':'string'
       }

# Open and read file

# Will produce xdr data one "line" at a time from the opened file
input = open(FileName, mode='rb').read() # 'r' for 'read', 'b' for 'binary'

unpacker = xdrlib.Unpacker(input) # class to unpack xdr data from the stream "data"

FileType = unpacker.unpack_string()

T_SE = array('d')
R_SE = array('d')
M_SE = array('d')
J_SE = array('d')
VarDict = { 'T_SE': T_SE, 'R_SE': R_SE, 'M_SE': M_SE, 'J_SE': J_SE } 

while 1:
    try:
        VarName = unpacker.unpack_string()
        VarType = unpacker.unpack_string()
        VarDim = unpacker.unpack_int()
        sys.stderr.write('> Found array %s with %s elements of type %s\n' %(VarName,VarDim,types[VarType]))
        VarDict[VarName].fromlist(unpacker.unpack_array(unpacker.unpack_double))
    except EOFError:
        break

# For historical reasons, arrays R_SE and M_SE have a supplementary (useless) element
del R_SE[0]
del M_SE[0]

print '# 1: R_SE 2: M_SE 3: T_SE 4: J_SE'
    
for (Ri,Mi,Ti,Ji) in zip (R_SE,M_SE,T_SE,J_SE):
    print '%15.8e %15.8e %15.8e %15.8e' % (Ri,Mi,Ti,Ji)

sys.exit(0)
