#!/usr/bin/ksh

Options=""

# traitement des options sur la ligne de commande
while [[ $1 = -* ]]; do
    Options=$Options" $1 $2"
    shift 2
done


ListeFich="$@"
[[ -z $ListeFich ]] && ListeFich=$(ls *AMAS.xdr 2>/dev/null) 

[[ -f input_EvolAmas ]] || {
    print -u2 '!!! No "input_EvolAmas" file in directory !!!'
    exit 1
}

NbSECouchePot=25
TailleAmas_en_pc=10
rNbEtoiles=1.0d6
Met_moy=1.0d0
Gamma_relax=0.14d0
fact_b0_kick=2.0d0

for var in NbSECouchePot rNbEtoiles TailleAmas_en_pc Gamma_relax fact_b0_kick; do
    eval $var=$(cat input_EvolAmas | grep -A1 "$var" | tail -n1 | sed 's/#..*//; s/ //g; s/[dD]/E/')
done

for file in $ListeFich; do
    NomFichTcarac=${file%.xdr}_Tcarac.asc.gz
    print -u2 "$file --> $NomFichTcarac"
    amas2tcarac -n $NbSECouchePot -Net $rNbEtoiles -T $TailleAmas_en_pc -Met $Met_moy -g $Gamma_relax -b $fact_b0_kick $Options $file | gzip -c > $NomFichTcarac
done

