#!/bin/zsh

other_options=""
nice_level=19
suffix=PorbPeriApo.asc

while [[ $1 = -* ]]; do
        case $1 in
                -nice ) nice_level=$2; shift 2 ;;
		-z  ) compress=1; shift 1 ;;
                *  )    print -u2 "!!! option $1 incorrecte !!!"
                                exit 1  ;;
        esac
done

[[ -z $compress ]] || suffix=$suffix".gz"

ListeFich=( $@ )

[[ -z $ListeFich ]] && ListeFich=( $(ls *AMAS.xdr 2>/dev/null) )

for file in $ListeFich; do
    out_file=${file%''%AMAS.xdr}%$suffix
    if [[ -f $out_file ]]; then
	print -u2 "> File $out_file exists; skipped"
    else
	print -u2 "> $file - - - - - > $out_file ..."
	command="nice -$nice_level amas2porbperiapocirc $file"
	if [[ -f $file ]]; then
	    {
		echo \# $0 ${date} Command used: 
		echo \# $command 
		eval $command 
	    } |\
	    if [[ -n $compress ]]; then
		gzip --to-stdout 
	    else
		cat
	    fi > $out_file
	fi
    fi
done

