#!/usr/bin/ksh

n_opt=75
n_min=""
n_max=""

while [[ $1 = -* ]]; do
        case $1 in
                -n_opt ) n_opt=$2
                        shift 2 ;;
                -n_min ) n_min=$2
                        shift 2 ;;
                -n_max ) n_max=$2
                        shift 2 ;;
                -e ) 	Ecrase=1
                	shift 1 ;;
                -z )    Compresse=1 
                	shift 1 ;;
                *  )    print -u2 "!!! option $1 incorrecte !!!"
                                exit 1  ;;
        esac
done

[[ -z $n_min ]] && n_min=10 
[[ -z $n_max ]] && n_max=5000
ListeFich="$@"

[[ -z $ListeFich ]] && ListeFich=$(ls *GRILLE.xdr 2>/dev/null) && FichGrille=1
[[ -z $ListeFich ]] && ListeFich=$(ls *AMAS.xdr 2>/dev/null) 

for fich in $ListeFich; do
	if [[ $fich = *%AMAS.xdr ]] ||[[ $fich = *%GRILLE.xdr ]]; then
	    NomFichGrille=${fich%""%*}"%GRILLE.asc"
	else
	    NomFichGrille=${fich%.xdr}_GRILLE.asc
	fi
	[[ -f $NomFichGrille ]] || [[ -f $NomFichGrille".gz" ]] && [[ -z ${Ecrase:+1} ]] && {
		print -u2 "> $NomFichGrille existe deja, on passe..."
	} || {
		NomFichGrille=$NomFichGrille${Compresse+".gz"}
		print -u2 "> Creation de $NomFichGrille..."
		if [[ -n ${FichGrille:+1} ]]; then
			grille_xdr2asc $fich
		else
			amas2pg -n_opt $n_opt -n_min  $n_min -n_max $n_max $fich
		fi |\
		\
		if [[ -n ${Compresse:+1} ]]; then
			gzip --to-stdout
		else
			cat
		fi > $NomFichGrille
	}
done
