#!/bin/zsh

FileList=( $@ )
[[ -z $FileList ]] && FileList=( $(find . -name "*%SubPop.asc*" | sort) )

#typeset -i Num 

NPart=$(( $(zcat.sh  $FileList[1] | grep -v '^#' | wc -l) + 0 ))
Vars=( $(zcat.sh  $FileList[1] | grep '^#' | tail -n 1 | sed 's/^# *1 *: *iSE//; s/ *[0-9][0-9]* *: */ /g; s/^ //; s/_SE//g') )
header=""
for i in $(seq 1 $NPart); do
    for Var in $Vars; do
	header=$header" "$Var"_"$i
    done
done
header="iStep"$header

{
    echo $header | sed 's/^ //'
    echo $header | sed 's/^ //; s/[^ ]/-/g'
    for File in $FileList; do
	Num=${File%""%*}
	Num=${Num#*%}
	echo $Num
	zcat.sh $File | grep -v '^#' | sed 's/  */ /g; s/^ //' | cut -d ' ' -f 2-5
    done |\
    gawk -v NPart=$NPart '{++line} line==1 {$1=$1+0} {printf "%s ", $0} line==NPart+1 {printf "\n"; line=0}'
} | tr ' ' '\011'