#!/usr/bin/env zsh

# Read in an ascii file containing N-body data (m x y z vx vy vz Rstar),
# where everyting is N-body unit (but Rstar which is in Rsun)
# and where the first particle is supposed to be a massive object
# and split it into a binary on a circular orbit (neglecting influence of other particles)


LC_ALL=C
export LC_ALL

zmodload zsh/mathfunc

command_line="$0 $@"

# Default values
#++++++++++++++++

BinMassRatio=1.0
BinSemi=1e-3 # in same units as the input file
BinStellarType=5 # 1 for MS stars, 5 for BHs
ZMBAR=0 # average mass in Msun for the input file; 
        # by default, we put it to a value such that the "stars" 
        # (not including the central stuff have 1 Msun on average

while [[ $1 = -* ]]; do
    case $1 in
        -(q|BinMassRatio)   ) BinMassRatio=$2; shift 2;;
        -(a|BinSemi)        ) Binsemi=$2; shift 2;;
        -(t|BinStellarType) ) BinStellarType=$2; shift 2;;
        -(ZMBAR) ) ZMBAR=$2; shift 2;;

        *       )
              print -u2 "!!! What exactly do you mean with $1, you magnificient weirdo? !!!"
              exit 1 ;;
    esac
done

cat > /tmp/_$$_TMP_in

cat /tmp/_$$_TMP_in | grep -v '^#' | head -n 2 | read m_bin x_bin y_bin z_bin vx_bin vy_bin vz_bin Rstar_bin
#print $m_bin $x_bin $y_bin $z_bin $vx_bin $vy_bin $vz_bin $Rstar_bin

N=$(cat  /tmp/_$$_TMP_in | grep -v '^#' | wc -l | sed 's/ //g')

if (( ZMBAR <= 0 )); then
    ZMBAR=$(cat  /tmp/_$$_TMP_in | grep '^# ZMBAR = ' | gawk '{print $4}' )
    if [[ -n $ZMBAR ]]; then
	print -u2 "> ZMBAR value of input file _found_ to be "$ZMBAR
    else
	ZMBAR=$(( (N-1.0)/N * 1.0/(1.0-m_bin) ))
	print -u2 "> ZMBAR value of input file _set_ to "$ZMBAR
    fi
fi

Vorb_bin=$(( (m_bin/BinSemi)**0.5 ))
mu1=$(( 1.0/(1.0+BinMassRatio) ))
mu2=$(( 1.0-mu1 ))
m1_Msun=$(( ZMBAR*mu1*m_bin ))
m2_Msun=$(( ZMBAR*mu2*m_bin ))
Rstar_1=$( echo $m1_Msun $BinStellarType | rel_mr | tail -n1 | gawk '{print $1}' )
Rstar_2=$( echo $m2_Msun $BinStellarType | rel_mr | tail -n1 | gawk '{print $1}' )

ZMBAR=$(( ZMBAR*N/(N+1.0) ))

cat  /tmp/_$$_TMP_in | grep '^#' | head --lines=-1
print '##----------------------------'
print "## Modification with $0 $@ ($(date) by $(whoami) on $(hostname))"
print "## Central object turned into a binary with"
print "##      BinMassRatio = $BinMassRatio"
print "##      BinSemi = $BinSemi"
print "##      BinStellarType = $BinStellarType (1 for MS stars, 5 for BHs)"
print "## New value of average mass in Msun:"
print "##      ZMBAR = $ZMBAR"
print '##----------------------------'
cat  /tmp/_$$_TMP_in | grep '^#' | tail -n 1

printf "%22.15e %22.15e %22.15e %22.15e %22.15e %22.15e %22.15e %12.5e\n" $(( mu1*m_bin )) $(( x_bin + mu2*BinSemi )) $y_bin $z_bin $vx_bin $(( vy_bin + mu2*Vorb_bin )) $vz_bin $Rstar_1
printf "%22.15e %22.15e %22.15e %22.15e %22.15e %22.15e %22.15e %12.5e\n" $(( mu2*m_bin )) $(( x_bin - mu1*BinSemi )) $y_bin $z_bin $vx_bin $(( vy_bin - mu1*Vorb_bin )) $vz_bin $Rstar_2

cat  /tmp/_$$_TMP_in | grep -v '^#' | tail --lines=+2

rm /tmp/_$$_TMP_*