#! /usr/bin/ksh

# Renomme tous les fichiers d'un repertoire de simulation d'amas
# en employant 10 caracteres pour le numero du pas
# par exemple _EvolAmas%123456789%AMAS.xdr --> _EvolAmas%0123456789%AMAS.xdr

Rep=${1:-"."}"/"

cd $Rep
typeset -Z10 iPas10
for Fich in $(ls -1 *%*%* | grep -E "..*%[0-9]{1,9}%..*"); do
    iPas=${Fich#*%}
    iPas=${iPas%"%"*}
    iPas10=$iPas
    NouvNom=${Fich%%%*}"%"$iPas10"%"${Fich##*%}
    print -u2 $Fich --> $NouvNom
    mv $Fich $NouvNom
done

