#! /bin/zsh

ls _EvolAmas%%FracSTSLag.asc(|.gz|.bz2) > /dev/null || {
    print -u2 "!!! No file _EvolAmas%%FracSTSLag.asc(|.gz|.bz2) !!!"
    exit 1
}

orig_files=( $(ls _EvolAmas%%Suivi??.asc(|.gz|.bz2)) )

zcat.sh _EvolAmas%%FracSTSLag.asc(|.gz|.bz2) | grep -v '^ *$' > $$_tmp1

nbcar=$(cat $$_tmp1 | gawk '{l=length(sprintf("%g",$1)); if (l>max){max=l}} END{print max-1}')
new_labels=( $(cat $$_tmp1 | gawk -v N=$nbcar '{ new=sprintf("%g",$1); sub(/\./,"",new); l=length(new); for(i=l+1;i<=N;i++){new=new "0"}; print new}') )

#print $new_labels[0]

ilab=0
i=0
line="#"
zcat.sh _EvolAmas%%SuiviMS.asc(|.gz|.bz2) | sed 's/  */ /g' | grep '^#' | tail -n1 | tr ' ' '\012' | grep -E '^[A-Za-z][A-Za-z_0-9]?' |\
while read name; do;
    echo $name | grep -qE '^N[0-9]+$' && {
	ilab=$(( ilab + 1 ))
	new=$new_labels[$ilab]
	old=$(echo $name | sed 's/^N//')
    }
    new_name=$(echo $name | sed 's/^\([A-Za-z_][A-Za-z_]*\)'$old'/\1'$new'/')
    #echo $name $new_name
    i=$(( i + 1 ))
    line=$line" "$i": "$new_name
done
#echo $line


for file in $orig_files; do
    [[ $file = *.gz ]] && {
	gunzip $file || exit 1
	file=${file%.gz}
    }
    [[ $file = *.bz2 ]] && {
	bunzip2 $file || exit 1
	file=${file%.bz2}
    }
    mv $file $file.BAK
    l=$(cat $file.BAK | grep '^#' | wc -l | sed 's/ //g')
    cat $file.BAK | gawk '++i=='$l' {$0="'$line'"} {print}' > $file
done

#zcat.sh _EvolAmas%%SuiviMS.asc(|.gz|.bz2) | sed 's/  */ /g' | tr ' ' '\012' | grep -E '^R[0-9]+' | sort # | paste - $$_tmp1

rm $$_tmp1

exit






# Fourni les fractions de masse correspondant a un fichier de Rayon Lagragiens
# (Suivi des differents types stellaires)

grep '^#' | tail -n1 | sed 's/^#//; s/[1-9][0-9]* *://g; s/   */ /g' | tr ' ' '\012' |\
gawk '/R[0-9][0-9]*/ {npos=length($1)-1;sub(/^R/,"",$1);print 10^(-npos+1)*$1" " $1}'

