#!/usr/bin/env python

import getopt, sys

from numpy import *
from pylab import load
import Nbody_Utils

print 'hello\n'
verb_level=1
output_format='%22.15e'

def usage():
    print "usage : " + sys.argv[0] + " [--eps_merg eps_value] nbody_snapshot.asc(.gz)"

def list2str(my_list) : # To print short list in a compact, space-less way
    if len(my_list)==0 :
        return ''
    else :
        i=0
        my_str=str(my_list[i])
        for i in range(1,len(my_list)) :
            my_str+=','+str(my_list[i])
    return my_str
    
def main():
    # Command-line arguments
    try:
        opts, args = getopt.getopt(sys.argv[1:], "e:", ["eps_merg="])
    except getopt.GetoptError:
        # print help information and exit:
        usage()
        sys.exit(2)
        
    eps_merg=0.0
    for o, a in opts:
        if o in ("-e", "--eps_merg"):
            eps_merg = float(a)
            sys.stderr.write(
                '>> Value of eps_merg set to %12.5e\n' % eps_merg
                )
    # ...
    
    # Open file and read all particles

    sys.stderr.write('>> Reading data ...')
    try:
        #data = load(args[0]) # much faster than read_array!
        m,x,y,z,vx,vy,vz = load(args[0], usecols=(0,1,2,3,4,5,6), unpack=True)
    except:
        # print help information and exit:
        usage()
        sys.exit(2)

    
    sys.stderr.write(' done. %i particles\n' % len(m))

    # Merging if required
    m,x,y,z,vx,vy,vz,iorigin = Nbody_Utils.merge_same_pos(m,x,y,z,vx,vy,vz,eps_merg,verb=verb_level)
    ###print '>> ', len(m),len(x),len(iorigin)
    N=len(m)

    # Compute density centre and sphericallized quantities (using this centre)
    ((R, vrad, vtan),(R_centre,V_centre)) = \
         Nbody_Utils.Nbody2Spherical(m,x,y,z,vx,vy,vz,verb=verb_level)
    
    # Write header
    print R_centre
    sys.stdout.write(
        '# N-body data sphericallized by %s\n' % ' '.join(sys.argv) + \
        '#\n' + \
        '# Density centre :\n' + \
        '# R_centre = '+ (3*(output_format+' ') % tuple(R_centre)) + '\n' + \
        '# V_centre = '+ (3*(output_format+' ') % tuple(V_centre)) + '\n' + \
        '#\n' + \
        '# 1: m 2: R 3: vrad 4: vtan 5: iparticles\n') 
    #for part_data in zip(m,R,vrad,vtan,iorigin) :
    #    sys.stdout.write((4*(output_format+' ') + '%s\n') % part_data)
    for (part_data,names) in zip(zip(m,R,vrad,vtan),iorigin) :
        sys.stdout.write((4*(output_format+' ')) % part_data + list2str(names) + '\n')

    sys.stderr.write(' done.')
    
if __name__ == "__main__":
    main()

