#!/usr/bin/python

import sys, re
match_step=re.compile(r"^\|  *iPas_Evol  *:  *([0-9]+)")
match_time=re.compile(r"^\|  *Tps_Ucode  *: .* Tps_Uncorps *:  *([^ ]+)  *Tps_en_yr *:  *([^ ]+)")

step=[]
time_in_yr=[]
time_in_FPunits=[]

for line in sys.stdin.readlines() :
    found_step=match_step.search(line)
    found_time=match_time.search(line)
    if found_step :
        latest_step = int(found_step.expand(r"\1"))
    if found_time :
        time_in_FPunits.append(float(found_time.expand(r"\1")))
        time_in_yr.append(float(found_time.expand(r"\2")))
        step.append(latest_step)

# to test:
#step=           [1,2,3,4,5,3,4,5,6,7,8,10,11,12,13,12,14,15,20]
#time_in_FPunits=[1,2,-3,-4,-5,3,4,5,6,7,8,10,11,-12,-13,12,14,15,20]

N=len(step)
higher_step = 1e30
j=N
for i in range(N-1,-1,-1) :
    if (step[i]<higher_step) :
        j-=1
        if i != j :
            step[j] = step[i]
            time_in_yr[j] = time_in_yr[i]
            time_in_FPunits[j] = time_in_FPunits[i]
        higher_step = step[j]
step=step[j:]
time_in_yr=time_in_yr[j:]
time_in_FPunits=time_in_FPunits[j:]

print "# 1: step 2: time_in_FPunits 3: time_in_yr"
for my_tuple in zip (step,time_in_FPunits,time_in_yr) :
    print '%i %15.8e %15.8e' % my_tuple
