#!/usr/bin/zsh

# Attempts to turn a _EvolAmas%%LC.asc file into a _EvolAmas%%Coll.asc !!
# Use it as a filter (to stdin from stdout)

# BEWARE: The only way to track the central mass is to assume it grows only by accreting stars without mass loss! Kind of stupid... Should write this info in the LC.asc file...



# Columns in  _EvolAmas%%Coll.asc are:
#-------------------------------------
# 1: iPas_evol 2: R_renc 3: iSE1 4: iSE2 5: Type1 6: Type2 7: Mini1 8: Mini2 9: Vrel_norm 10: b_norm 11: Mfin1 12: Mfin2 13: Vrel_norm_p 14: Theta 15: Pot1 16: Pot2 17: Age_ini1 18: Age_ini2 19: Age_fin1 20: Age_fin2

# Colums in  _EvolAmas%%LC.asc are:
#----------------------------------
# Donnees sur les etoiles dechirees ou traversant l'horizon
# Valeurs de |iFlagLC|: FULL=1,EMPTY=2,COLL=3,GW=11; <0 si traversee directe
# 1:iPas_Evol 2:iSE 3:R_SE 4:E_SE 5:J_SE 6:iTet_SE 7:Met_SE 8:Theta_disp 9:Theta_dechir 10:dt_renc 11:Porb_quad 12:Beta_dechir 13:iFlagLC 14:dE 15:Pot_Ctr 16:Trel_renc 17:Trel_loc 18: Trel_orb 19:Peri 20:Apo

# Initial value of central mass
[[ -f input_EvolAmas ]] || {
    print -u2 "!!! Need input_EvolAmas to get initial mass of central object !!!"
    exit 1
}
M_TN_ini_def=$(cat input_EvolAmas | grep -a2 '^M_TN_ini_def' | tail -n2 | head -n1 | sed 's/^ *//; s/ *#.*//')
rNbEtoiles=$(cat input_EvolAmas | grep -a2 '^rNbEtoiles' | tail -n2 | head -n1 | sed 's/^ *//; s/ *#.*//')
MasseEtoileDef=$(cat input_EvolAmas | grep -a2 '^MasseEtoileDef' | tail -n2 | head -n1 | sed 's/^ *//; s/ *#.*//')
Mctr=$(( M_TN_ini_def * rNbEtoiles * MasseEtoileDef ))
print -u2 "> Initial mass of central star is $Mctr Msun"

# Default values

iPas_evol=0
R_renc=0
iSE1=0
iSE2=0
Type1=0
Type2=0
Mini1=0
Mini2=0
Vrel_norm=0
b_norm=0
Mfin1=0
Mfin2=0
Vrel_norm_p=0
Theta=0
Pot1=0
Pot2=0
Age_ini1=0
Age_ini2=0
Age_fin1=0
Age_fin2=0

cat<<EOF
# %%LC.asc file turned into %%Coll.asc by $0
# 1: iPas_evol 2: R_renc 3: iSE1 4: iSE2 5: Type1 6: Type2 7: Mini1 8: Mini2 9: Vrel_norm 10: b_norm 11: Mfin1 12: Mfin2 13: Vrel_norm_p 14: Theta 15: Pot1 16: Pot2 17: Age_ini1 18: Age_ini2 19: Age_fin1 20: Age_fin2
EOF

grep -v '^#' |\
while read iPas_evol iSE R_SE E_SE J_SE iTet_SE Met_SE Theta_disp Theta_dechir dt_renc Porb_quad Beta_dechir iFlagLC dE Pot_Ctr Trel_renc Trel_loc Trel_orb Peri Apo; do
    R_renc=$Peri
    iSE1=$iSE
    iSE2=0
    Type1=$iTet_SE
    Type2=1 # MS star
    Mini1=$Met_SE
    Mini2=$Mctr
    Vrel_norm=-1 # One may do better...
    b_norm=-1    # Here too
    Mfin1=0
    Mctr=$(gawk 'BEGIN{print '$Mini1'+'$Mctr'; exit}')
    Mfin2=$Mctr
    Pot1=$Pot_Ctr
    Pot2=$Pot_Ctr
    Age_ini1=-1
    Age_ini2=-1
    Age_fin1=-1
    Age_fin2=-1
    echo $iPas_evol $R_renc $iSE1 $iSE2 $Type1 $Type2 $Mini1 $Mini2 $Vrel_norm $b_norm $Mfin1 $Mfin2 $Vrel_norm_p $Theta $Pot1 $Pot2 $Age_ini1 $Age_ini2 $Age_fin1 $Age_fin2
done