#! /bin/zsh -f

# On fait des grilles de profil (une par type stellaire) pour un amas represente 
# par les fichiers $1AMAS.xdr et $1ETOILES.xdr

NomBase=$1
NomBase=${NomBase%""AMAS.xdr}
tmp=/tmp/tmp_$$

n_max=10000

[[ -f $NomBase"ETOILES.xdr" ]] || {
    print -u2 "!!! Le fichier "$NomBase"ETOILES.xdr n'existe pas !!!"
    exit 1
}
[[ -f $NomBase"ETOILES.xdr" ]] || {
    print -u2 "!!! Le fichier "$NomBase"ETOILES.xdr n'existe pas !!!"
    exit 1
}

Ventille_Amas_TypesStell $NomBase"AMAS.xdr" $NomBase"ETOILES.xdr" $tmp
NomBase=${NomBase%""%}"%"

for Type in MS RG WD NS BH; do
    if [[ -f $tmp"_AMAS:"$Type".xdr" ]]; then
	NbPart=$(nbse_xdr $tmp"_AMAS:"$Type".xdr" | sed 's/ //g')
	n_opt=$(calc.sh "int(300*(1e-5*$NbPart)^0.7)")
	(( n_opt > 1000 )) && n_opt=1000
	(( n_opt < 10 )) && n_opt=10
	n_min=$(calc.sh "int($n_opt/20)")
	(( n_min < 3 )) && n_min=3
	(( n_min > 20 )) && n_min=20
	print -u2 "> Type $Type N_part=$NbPart" # n_min=$n_min n_opt=$n_opt n_max=$n_max"
	pwd
	#n_opt=75
	#n_min=5
	#n_max=1000
	amas2pg_5M -n_opt $n_opt -n_min $n_min -n_max $n_max $tmp"_AMAS:"$Type".xdr" >  $NomBase"GRILLE:"$Type".asc"
	print -u2 "> Fichier "$NomBase"GRILLE:"$Type".asc cree."
    fi
done

rm $tmp""*

	