#! /bin/zsh 


# On fait des grilles de profil ventilees en fct de la masse initiale des etoiles
# pour un amas represente par le fichiers $1AMAS.xdr
# les 'centres' des bins de masse sont les arguments suivants sur la ligne de commande

Nom=$1

NomFichAmas=${Nom##*/}
NomRep=${Nom%$NomFichAmas}
NomRep=${NomRep:-"."}

shift 1
ListeBins=( "$@" )

tmp=/tmp/tmp_$$

# on doit se placer dans le bon repertoire
cd $NomRep

n_max=10000

[[ -f $NomFichAmas ]] || {
    print -u2 "!!! Le fichier "$NomFichAmas" n'existe pas !!!"
    exit 1
}

ventille_amas_mst_ini $NomFichAmas $ListeBins

# Lecture du fichier de donnees sur la 'ventilation'
FichVentil=${NomFichAmas%AMAS.xdr}"Mst_ini_bins.asc"
ListeFichXDR=( $(cat $FichVentil | gawk '/^[^#]/ {print $1}') )

for FichXDR in $ListeFichXDR; do
    if [[ -f $FichXDR ]]; then
	NbPart=$(nbse_xdr $FichXDR | sed 's/ //g')
	n_opt=$(calc.sh "int(sqrt($NbPart))")
	(( n_opt > 1000 )) && n_opt=1000
	(( n_opt < 10 )) && n_opt=10
	n_min=$(calc.sh "int($n_opt/20)")
	(( n_min < 3 )) && n_min=3
	(( n_min > 20 )) && n_min=20
	print -u2 "> Fichier $FichXDR N_part=$NbPart" # n_min=$n_min n_opt=$n_opt n_max=$n_max"
	FichGrille=${FichXDR%AMAS*}GRILLE${${FichXDR#*AMAS}%.xdr}.asc 
	amas2pg -n_opt $n_opt -n_min $n_min -n_max $n_max $FichXDR > $FichGrille
	print -u2 "> Fichier $FichGrille cree."
    fi
done

[[ ! -f $tmp ]] || rm $tmp

	